/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class IntValuesComparator
extends LongValuesComparatorBase<Integer> {
    private final int[] values;

    public IntValuesComparator(IndexNumericFieldData<?> indexFieldData, int missingValue, int numHits, SortMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        assert (indexFieldData.getNumericType().requiredBits() <= 32);
        this.values = new int[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        int v1 = this.values[slot1];
        int v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = (int)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public Integer value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + (int)this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = (int)this.missingValue;
    }
}

