/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData<?> indexFieldData;
    private final Object missingValue;
    private final SortMode sortMode;

    public DoubleValuesComparatorSource(IndexNumericFieldData<?> indexFieldData, @Nullable Object missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed2) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        double dMissingValue = this.missingValue == null || "_last".equals(this.missingValue) ? (reversed2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : ("_first".equals(this.missingValue) ? (reversed2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : (this.missingValue instanceof Number ? ((Number)this.missingValue).doubleValue() : Double.parseDouble(this.missingValue.toString())));
        return new DoubleValuesComparator(this.indexFieldData, dMissingValue, numHits, this.sortMode);
    }
}

