/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.script.SearchScript;

public class DoubleScriptDataComparator
extends NumberComparatorBase<Double> {
    private final SearchScript script;
    private final double[] values;
    private double bottom;

    public static IndexFieldData.XFieldComparatorSource comparatorSource(SearchScript script) {
        return new InnerSource(script);
    }

    public DoubleScriptDataComparator(int numHits, SearchScript script) {
        this.script = script;
        this.values = new double[numHits];
    }

    @Override
    public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
        this.script.setNextReader(context);
        return this;
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }

    @Override
    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareBottom(int doc) {
        this.script.setNextDocId(doc);
        double v2 = this.script.runAsDouble();
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareDocToValue(int doc, Double val2) throws IOException {
        this.script.setNextDocId(doc);
        double val1 = this.script.runAsDouble();
        return Double.compare(val1, val2);
    }

    @Override
    public void copy(int slot, int doc) {
        this.script.setNextDocId(doc);
        this.values[slot] = this.script.runAsDouble();
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    @Override
    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        this.script.setNextDocId(doc);
        int n = slot;
        this.values[n] = this.values[n] + this.script.runAsDouble();
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (double)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = Double.MAX_VALUE;
    }

    @Override
    public int compareBottomMissing() {
        return Double.compare(this.bottom, Double.MAX_VALUE);
    }

    private static class InnerSource
    extends IndexFieldData.XFieldComparatorSource {
        private final SearchScript script;

        private InnerSource(SearchScript script) {
            this.script = script;
        }

        public FieldComparator<? extends Number> newComparator(String fieldname, int numHits, int sortPos, boolean reversed2) throws IOException {
            return new DoubleScriptDataComparator(numHits, this.script);
        }

        @Override
        public SortField.Type reducedType() {
            return SortField.Type.DOUBLE;
        }
    }
}

