/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardFieldData
extends AbstractIndexShardComponent
implements IndexFieldDataCache.Listener {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    @Inject
    public ShardFieldData(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public FieldDataStats stats(String ... fields) {
        ObjectLongOpenHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongOpenHashMap<String>();
            for (Map.Entry entry2 : this.perFieldTotals.entrySet()) {
                for (String field2 : fields) {
                    if (!Regex.simpleMatch(field2, (String)entry2.getKey())) continue;
                    fieldTotals.put((String)entry2.getKey(), ((CounterMetric)entry2.getValue()).count());
                }
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals);
    }

    @Override
    public void onLoad(FieldMapper.Names fieldNames, FieldDataType fieldDataType, AtomicFieldData fieldData) {
        long sizeInBytes2 = fieldData.getMemorySizeInBytes();
        this.totalMetric.inc(sizeInBytes2);
        String keyFieldName = fieldNames.indexName();
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
        if (total != null) {
            total.inc(sizeInBytes2);
        } else {
            total = new CounterMetric();
            total.inc(sizeInBytes2);
            CounterMetric prev = this.perFieldTotals.putIfAbsent(keyFieldName, total);
            if (prev != null) {
                prev.inc(sizeInBytes2);
            }
        }
    }

    @Override
    public void onUnload(FieldMapper.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes2, @Nullable AtomicFieldData fieldData) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes2 != -1L) {
            this.totalMetric.dec(sizeInBytes2);
            String keyFieldName = fieldNames.indexName();
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
            if (total != null) {
                total.dec(sizeInBytes2);
            }
        }
    }
}

