/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public interface IndexNumericFieldData<FD extends AtomicNumericFieldData>
extends IndexFieldData<FD> {
    public NumericType getNumericType();

    @Override
    public FD load(AtomicReaderContext var1);

    @Override
    public FD loadDirect(AtomicReaderContext var1) throws Exception;

    public static enum NumericType {
        BYTE{

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public int requiredBits() {
                return 8;
            }
        }
        ,
        SHORT{

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public int requiredBits() {
                return 16;
            }
        }
        ,
        INT{

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public int requiredBits() {
                return 32;
            }
        }
        ,
        LONG{

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public int requiredBits() {
                return 64;
            }
        }
        ,
        FLOAT{

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public int requiredBits() {
                return 32;
            }
        }
        ,
        DOUBLE{

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public int requiredBits() {
                return 64;
            }
        };


        public abstract boolean isFloatingPoint();

        public abstract int requiredBits();

        public final TermsEnum wrapTermsEnum(TermsEnum termsEnum) {
            if (this.requiredBits() > 32) {
                return OrdinalsBuilder.wrapNumeric64Bit(termsEnum);
            }
            return OrdinalsBuilder.wrapNumeric32Bit(termsEnum);
        }
    }
}

