/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DisabledIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FSTBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FloatArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PackedArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;

public class IndexFieldDataService
extends AbstractIndexComponent {
    private static final String DISABLED_FORMAT = "disabled";
    private static final String ARRAY_FORMAT = "array";
    private static final String PAGED_BYTES_FORMAT = "paged_bytes";
    private static final String FST_FORMAT = "fst";
    private static final String COMPRESSED_FORMAT = "compressed";
    private static final ImmutableMap<String, IndexFieldData.Builder> buildersByType = MapBuilder.newMapBuilder().put("string", new PagedBytesIndexFieldData.Builder()).put("float", (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put("double", (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put("byte", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put("short", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put("int", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put("long", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put("geo_point", (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).immutableMap();
    private static final ImmutableMap<Tuple<String, String>, IndexFieldData.Builder> buildersByTypeAndFormat = MapBuilder.newMapBuilder().put(Tuple.tuple("string", "paged_bytes"), new PagedBytesIndexFieldData.Builder()).put(Tuple.tuple("string", "fst"), (PagedBytesIndexFieldData.Builder)((Object)new FSTBytesIndexFieldData.Builder())).put(Tuple.tuple("string", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("float", "array"), (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put(Tuple.tuple("float", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("double", "array"), (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("double", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("byte", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("short", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("int", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("long", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "array"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "compressed"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointCompressedIndexFieldData.Builder())).immutableMap();
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final ConcurrentMap<String, IndexFieldData<?>> loadedFieldData = ConcurrentCollections.newConcurrentMap();
    private final Map<String, IndexFieldDataCache> fieldDataCaches = Maps.newHashMap();
    IndexService indexService;

    public IndexFieldDataService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, new IndicesFieldDataCache(ImmutableSettings.Builder.EMPTY_SETTINGS));
    }

    @Inject
    public IndexFieldDataService(Index index, @IndexSettings Settings indexSettings, IndicesFieldDataCache indicesFieldDataCache) {
        super(index, indexSettings);
        this.indicesFieldDataCache = indicesFieldDataCache;
    }

    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            for (IndexFieldData fieldData : this.loadedFieldData.values()) {
                fieldData.clear();
            }
            this.loadedFieldData.clear();
            for (IndexFieldDataCache cache : this.fieldDataCaches.values()) {
                cache.clear();
            }
            this.fieldDataCaches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearField(String fieldName) {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            IndexFieldDataCache cache;
            IndexFieldData fieldData = (IndexFieldData)this.loadedFieldData.remove(fieldName);
            if (fieldData != null) {
                fieldData.clear();
            }
            if ((cache = this.fieldDataCaches.remove(fieldName)) != null) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IndexReader reader) {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            for (IndexFieldData indexFieldData : this.loadedFieldData.values()) {
                indexFieldData.clear(reader);
            }
            for (IndexFieldDataCache cache : this.fieldDataCaches.values()) {
                cache.clear(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMappingUpdate() {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            this.loadedFieldData.clear();
        }
    }

    public <IFD extends IndexFieldData> IFD getForField(FieldMapper mapper) {
        return this.getForField(mapper.names(), mapper.fieldDataType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IFD extends IndexFieldData> IFD getForField(FieldMapper.Names fieldNames, FieldDataType type) {
        IndexFieldData fieldData = (IndexFieldData)this.loadedFieldData.get(fieldNames.indexName());
        if (fieldData == null) {
            ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
            synchronized (concurrentMap) {
                fieldData = (IndexFieldData)this.loadedFieldData.get(fieldNames.indexName());
                if (fieldData == null) {
                    IndexFieldData.Builder builder = null;
                    String format2 = type.getSettings().get("format", this.indexSettings.get("index.fielddata.type." + type.getType() + ".format", null));
                    if (format2 != null && (builder = buildersByTypeAndFormat.get(Tuple.tuple(type.getType(), format2))) == null) {
                        this.logger.warn("failed to find format [" + format2 + "] for field [" + fieldNames.fullName() + "], will use default", new Object[0]);
                    }
                    if (builder == null) {
                        builder = buildersByType.get(type.getType());
                    }
                    if (builder == null) {
                        throw new ElasticSearchIllegalArgumentException("failed to find field data builder for field " + fieldNames.fullName() + ", and type " + type.getType());
                    }
                    IndexFieldDataCache cache = this.fieldDataCaches.get(fieldNames.indexName());
                    if (cache == null) {
                        String cacheType = type.getSettings().get("cache", this.indexSettings.get("index.fielddata.cache", "node"));
                        if ("resident".equals(cacheType)) {
                            cache = new IndexFieldDataCache.Resident(this.indexService, fieldNames, type);
                        } else if ("soft".equals(cacheType)) {
                            cache = new IndexFieldDataCache.Soft(this.indexService, fieldNames, type);
                        } else if ("node".equals(cacheType)) {
                            cache = this.indicesFieldDataCache.buildIndexFieldDataCache(this.indexService, this.index, fieldNames, type);
                        } else {
                            throw new ElasticSearchIllegalArgumentException("cache type not supported [" + cacheType + "] for field [" + fieldNames.fullName() + "]");
                        }
                        this.fieldDataCaches.put(fieldNames.indexName(), cache);
                    }
                    fieldData = builder.build(this.index, this.indexSettings, fieldNames, type, cache);
                    this.loadedFieldData.put(fieldNames.indexName(), fieldData);
                }
            }
        }
        return (IFD)fieldData;
    }
}

