/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public interface IndexFieldData<FD extends AtomicFieldData>
extends IndexComponent {
    public FieldMapper.Names getFieldNames();

    public boolean valuesOrdered();

    public FD load(AtomicReaderContext var1);

    public FD loadDirect(AtomicReaderContext var1) throws Exception;

    public XFieldComparatorSource comparatorSource(@Nullable Object var1, SortMode var2);

    public void clear();

    public void clear(IndexReader var1);

    @Deprecated
    public long getHighestNumberOfSeenUniqueValues();

    public static interface WithOrdinals<FD extends AtomicFieldData.WithOrdinals>
    extends IndexFieldData<FD> {
        @Override
        public FD load(AtomicReaderContext var1);

        @Override
        public FD loadDirect(AtomicReaderContext var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData build(Index var1, @IndexSettings Settings var2, FieldMapper.Names var3, FieldDataType var4, IndexFieldDataCache var5);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        public abstract SortField.Type reducedType();
    }

    public static class CommonSettings {
        public static boolean removeOrdsOnSingleValue(FieldDataType fieldDataType) {
            return !"always".equals(fieldDataType.getSettings().get("ordinals"));
        }
    }
}

