/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.FieldMapper;

public class FieldDataType {
    public static final String FORMAT_KEY = "format";
    private final String type;
    private final FieldMapper.Loading loading;
    private final Settings settings;

    public FieldDataType(String type) {
        this(type, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public FieldDataType(String type, Settings.Builder builder) {
        this(type, builder.build());
    }

    public FieldDataType(String type, Settings settings) {
        this.type = type;
        this.settings = settings;
        String loading = settings.get("loading");
        this.loading = FieldMapper.Loading.parse(loading, FieldMapper.Loading.LAZY);
    }

    public String getType() {
        return this.type;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public FieldMapper.Loading getLoading() {
        return this.loading;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDataType that = (FieldDataType)o;
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.settings.hashCode();
        return result2;
    }
}

