/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FieldDataStats
implements Streamable,
ToXContent {
    long memorySize;
    long evictions;
    @Nullable
    ObjectLongOpenHashMap<String> fields;

    public FieldDataStats() {
    }

    public FieldDataStats(long memorySize, long evictions, @Nullable ObjectLongOpenHashMap<String> fields) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.fields = fields;
    }

    public void add(FieldDataStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        if (stats.fields != null) {
            if (this.fields == null) {
                this.fields = new ObjectLongOpenHashMap();
            }
            boolean[] states = stats.fields.allocated;
            KType[] keys = stats.fields.keys;
            long[] values2 = stats.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                this.fields.addTo((String)keys[i], values2[i]);
            }
        }
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    @Nullable
    public ObjectLongOpenHashMap<String> getFields() {
        return this.fields;
    }

    public static FieldDataStats readFieldDataStats(StreamInput in) throws IOException {
        FieldDataStats stats = new FieldDataStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        if (in.readBoolean()) {
            int size2 = in.readVInt();
            this.fields = new ObjectLongOpenHashMap(size2);
            for (int i = 0; i < size2; ++i) {
                this.fields.put(in.readString(), in.readVLong());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        if (this.fields == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fields.size());
            boolean[] states = this.fields.allocated;
            KType[] keys = this.fields.keys;
            long[] values2 = this.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                out.writeString((String)keys[i]);
                out.writeVLong(values2[i]);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FIELDDATA);
        builder.byteSizeField(Fields.MEMORY_SIZE_IN_BYTES, Fields.MEMORY_SIZE, this.memorySize);
        builder.field(Fields.EVICTIONS, this.getEvictions());
        if (this.fields != null) {
            builder.startObject(Fields.FIELDS);
            boolean[] states = this.fields.allocated;
            KType[] keys = this.fields.keys;
            long[] values2 = this.fields.values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                builder.startObject((String)keys[i], XContentBuilder.FieldCaseConversion.NONE);
                builder.byteSizeField(Fields.MEMORY_SIZE_IN_BYTES, Fields.MEMORY_SIZE, values2[i]);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FIELDDATA = new XContentBuilderString("fielddata");
        static final XContentBuilderString MEMORY_SIZE = new XContentBuilderString("memory_size");
        static final XContentBuilderString MEMORY_SIZE_IN_BYTES = new XContentBuilderString("memory_size_in_bytes");
        static final XContentBuilderString EVICTIONS = new XContentBuilderString("evictions");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");

        Fields() {
        }
    }
}

