/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class AtomicGeoPointFieldData<Script extends ScriptDocValues>
implements AtomicFieldData<Script> {
    public abstract GeoPointValues getGeoPointValues();

    @Override
    public BytesValues getBytesValues(boolean needsHashes) {
        final GeoPointValues values2 = this.getGeoPointValues();
        return new BytesValues(values2.isMultiValued()){

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return values2.setDocument(docId);
            }

            @Override
            public BytesRef nextValue() {
                GeoPoint value2 = values2.nextValue();
                this.scratch.copyChars(GeoHashUtils.encode(value2.lat(), value2.lon()));
                return this.scratch;
            }
        };
    }
}

