/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractIndexFieldData<FD extends AtomicFieldData>
extends AbstractIndexComponent
implements IndexFieldData<FD> {
    private final FieldMapper.Names fieldNames;
    private final AtomicLong highestUniqueValuesCount = new AtomicLong();
    protected final FieldDataType fieldDataType;
    protected final IndexFieldDataCache cache;

    public AbstractIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings);
        this.fieldNames = fieldNames;
        this.fieldDataType = fieldDataType;
        this.cache = cache;
    }

    @Override
    public FieldMapper.Names getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void clear() {
        this.cache.clear(this.fieldNames.indexName());
    }

    @Override
    public void clear(IndexReader reader) {
        this.cache.clear(reader);
    }

    @Override
    public long getHighestNumberOfSeenUniqueValues() {
        return this.highestUniqueValuesCount.get();
    }

    @Override
    public final FD load(AtomicReaderContext context) {
        try {
            Object fd = this.cache.load(context, this);
            this.updateHighestSeenValuesCount(fd.getNumberUniqueValues());
            return fd;
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    private void updateHighestSeenValuesCount(long newValuesCount) {
        long current;
        while ((current = this.highestUniqueValuesCount.get()) < newValuesCount && !this.highestUniqueValuesCount.compareAndSet(current, newValuesCount)) {
        }
    }
}

