/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.robin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineAlreadyStartedException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.indices.warmer.InternalIndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class RobinEngine
extends AbstractIndexShardComponent
implements Engine {
    private volatile ByteSizeValue indexingBufferSize;
    private volatile int indexConcurrency;
    private volatile boolean compoundOnFlush = true;
    private long gcDeletesInMillis;
    private volatile boolean enableGcDeletes = true;
    private volatile String codecName;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    private final IndexSettingsService indexSettingsService;
    @Nullable
    private final InternalIndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final AnalysisService analysisService;
    private final SimilarityService similarityService;
    private final CodecService codecService;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile IndexWriter indexWriter;
    private final SearcherFactory searcherFactory = new RobinSearchFactory();
    private volatile SearcherManager searcherManager;
    private volatile boolean closed = false;
    private volatile boolean dirty = false;
    private volatile boolean possibleMergeNeeded = false;
    private final AtomicBoolean optimizeMutex = new AtomicBoolean();
    private volatile boolean flushNeeded = false;
    private final AtomicInteger flushing = new AtomicInteger();
    private final Lock flushLock = new ReentrantLock();
    private final RecoveryCounter onGoingRecoveries = new RecoveryCounter();
    private final ConcurrentMap<HashedBytesRef, VersionValue> versionMap;
    private final Object[] dirtyLocks;
    private final Object refreshMutex = new Object();
    private final ApplySettings applySettings = new ApplySettings();
    private volatile boolean failOnMergeFailure;
    private Throwable failedEngine = null;
    private final Object failedEngineMutex = new Object();
    private final CopyOnWriteArrayList<Engine.FailedEngineListener> failedEngineListeners = new CopyOnWriteArrayList();
    private final AtomicLong translogIdGenerator = new AtomicLong();
    private SegmentInfos lastCommittedSegmentInfos;
    private static boolean allowRamBytesUsed = false;
    public static final String INDEX_INDEX_CONCURRENCY = "index.index_concurrency";
    public static final String INDEX_COMPOUND_ON_FLUSH = "index.compound_on_flush";
    public static final String INDEX_GC_DELETES = "index.gc_deletes";
    public static final String INDEX_FAIL_ON_MERGE_FAILURE = "index.fail_on_merge_failure";

    @Inject
    public RobinEngine(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService, ShardIndexingService indexingService, @Nullable IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, AnalysisService analysisService, SimilarityService similarityService, CodecService codecService) throws EngineException {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the engine");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the engine");
        Preconditions.checkNotNull(translog, "Translog must be provided to the engine");
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES, TimeValue.timeValueSeconds(60L)).millis();
        this.indexingBufferSize = this.componentSettings.getAsBytesSize("index_buffer_size", new ByteSizeValue(64L, ByteSizeUnit.MB));
        this.codecName = indexSettings.get("index.codec", "default");
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexingService = indexingService;
        this.warmer = (InternalIndicesWarmer)warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analysisService = analysisService;
        this.similarityService = similarityService;
        this.codecService = codecService;
        this.compoundOnFlush = indexSettings.getAsBoolean(INDEX_COMPOUND_ON_FLUSH, (Boolean)this.compoundOnFlush);
        this.indexConcurrency = indexSettings.getAsInt(INDEX_INDEX_CONCURRENCY, (Integer)Math.max(8, (int)((double)EsExecutors.boundedNumberOfProcessors(indexSettings) * 0.65)));
        this.versionMap = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        this.dirtyLocks = new Object[this.indexConcurrency * 50];
        for (int i = 0; i < this.dirtyLocks.length; ++i) {
            this.dirtyLocks[i] = new Object();
        }
        this.indexSettingsService.addListener(this.applySettings);
        this.failOnMergeFailure = indexSettings.getAsBoolean(INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)true);
        if (this.failOnMergeFailure) {
            this.mergeScheduler.addFailureListener(new FailEngineOnMergeFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        ByteSizeValue preValue = this.indexingBufferSize;
        this.rwl.readLock().lock();
        try {
            this.indexingBufferSize = indexingBufferSize;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter != null) {
                indexWriter.getConfig().setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (preValue.bytes() != indexingBufferSize.bytes()) {
            if (indexingBufferSize == Engine.INACTIVE_SHARD_INDEXING_BUFFER && preValue != Engine.INACTIVE_SHARD_INDEXING_BUFFER) {
                this.logger.debug("updating index_buffer_size from [{}] to (inactive) [{}]", preValue, indexingBufferSize);
                try {
                    this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
                catch (EngineClosedException e) {
                }
                catch (FlushNotAllowedEngineException e) {
                }
                catch (Throwable e) {
                    this.logger.warn("failed to flush after setting shard to inactive", e, new Object[0]);
                }
            } else {
                this.logger.debug("updating index_buffer_size from [{}] to [{}]", preValue, indexingBufferSize);
            }
        }
    }

    @Override
    public void addFailedEngineListener(Engine.FailedEngineListener listener) {
        this.failedEngineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void start() throws EngineException {
        this.rwl.writeLock().lock();
        try {
            if (this.indexWriter != null) {
                throw new EngineAlreadyStartedException(this.shardId);
            }
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("starting engine", new Object[0]);
            }
            try {
                this.indexWriter = this.createWriter();
            }
            catch (IOException e) {
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
            }
            try {
                if (Lucene.indexExists(this.store.directory())) {
                    Map<String, String> commitUserData = Lucene.readSegmentInfos(this.store.directory()).getUserData();
                    if (commitUserData.containsKey("translog_id")) {
                        this.translogIdGenerator.set(Long.parseLong(commitUserData.get("translog_id")));
                    } else {
                        this.translogIdGenerator.set(System.currentTimeMillis());
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                        this.indexWriter.commit();
                    }
                } else {
                    this.translogIdGenerator.set(System.currentTimeMillis());
                    this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                    this.indexWriter.commit();
                }
                this.translog.newTranslog(this.translogIdGenerator.get());
                this.searcherManager = this.buildSearchManager(this.indexWriter);
                this.readLastCommittedSegmentsInfo();
            }
            catch (IOException e) {
                block19: {
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException iOException) {
                        IOUtils.closeWhileHandlingException(this.indexWriter);
                        break block19;
                        catch (Throwable throwable) {
                            IOUtils.closeWhileHandlingException(this.indexWriter);
                            throw throwable;
                        }
                    }
                    IOUtils.closeWhileHandlingException(this.indexWriter);
                }
                throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", (Throwable)e);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void readLastCommittedSegmentsInfo() throws IOException {
        SegmentInfos infos = new SegmentInfos();
        infos.read(this.store.directory());
        this.lastCommittedSegmentInfos = infos;
    }

    @Override
    public TimeValue defaultRefreshInterval() {
        return new TimeValue(1L, TimeUnit.SECONDS);
    }

    @Override
    public void enableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 11[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void create(Engine.Create create2) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerCreate(create2, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new CreateFailedEngineException(this.shardId, create2, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new CreateFailedEngineException(this.shardId, create2, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new CreateFailedEngineException(this.shardId, create2, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create2, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(create2.uid());
        synchronized (object) {
            long updatedVersion;
            UidField uidField = create2.uidField();
            HashedBytesRef versionKey = this.versionKey(create2.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create2.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (create2.origin() == Engine.Operation.Origin.PRIMARY) {
                if (create2.versionType() == VersionType.INTERNAL) {
                    long expectedVersion = create2.version();
                    if (expectedVersion != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, create2.type(), create2.id(), -1L, expectedVersion);
                        }
                        if (expectedVersion != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, create2.type(), create2.id(), currentVersion, expectedVersion);
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion >= 0L && currentVersion >= create2.version()) {
                        throw new VersionConflictEngineException(this.shardId, create2.type(), create2.id(), currentVersion, create2.version());
                    }
                    updatedVersion = create2.version();
                }
            } else {
                long expectedVersion = create2.version();
                if (currentVersion != -2L && (currentVersion != -1L || create2.version() != 1L) && expectedVersion <= currentVersion) {
                    if (create2.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, create2.type(), create2.id(), currentVersion, expectedVersion);
                }
                updatedVersion = create2.version();
            }
            if (versionValue != null) {
                if (!versionValue.delete()) {
                    if (create2.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new DocumentAlreadyExistsException(this.shardId, create2.type(), create2.id());
                }
            } else if (currentVersion != -1L) {
                if (create2.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new DocumentAlreadyExistsException(this.shardId, create2.type(), create2.id());
            }
            uidField.version(updatedVersion);
            create2.version(updatedVersion);
            if (create2.docs().size() > 1) {
                writer.addDocuments(create2.docs(), create2.analyzer());
            } else {
                writer.addDocument(create2.docs().get(0), create2.analyzer());
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Create(create2));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postCreateUnderLock(create2);
        }
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerIndex(index, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            long updatedVersion;
            UidField uidField = index.uidField();
            HashedBytesRef versionKey = this.versionKey(index.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (index.origin() == Engine.Operation.Origin.PRIMARY) {
                if (index.versionType() == VersionType.INTERNAL) {
                    long expectedVersion = index.version();
                    if (expectedVersion != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), -1L, expectedVersion);
                        }
                        if (expectedVersion != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion >= 0L && currentVersion >= index.version()) {
                        throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, index.version());
                    }
                    updatedVersion = index.version();
                }
            } else {
                long expectedVersion = index.version();
                if (currentVersion != -2L && (currentVersion != -1L || index.version() != 1L) && expectedVersion <= currentVersion) {
                    if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                }
                updatedVersion = index.version();
            }
            uidField.version(updatedVersion);
            index.version(updatedVersion);
            if (currentVersion == -1L) {
                if (index.docs().size() > 1) {
                    writer.addDocuments(index.docs(), index.analyzer());
                } else {
                    writer.addDocument(index.docs().get(0), index.analyzer());
                }
            } else if (index.docs().size() > 1) {
                writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
            } else {
                writer.updateDocument(index.uid(), index.docs().get(0), index.analyzer());
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postIndexUnderLock(index);
        }
    }

    @Override
    public void delete(Engine.Delete delete2) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerDelete(delete2, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteFailedEngineException(this.shardId, delete2, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new DeleteFailedEngineException(this.shardId, delete2, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new DeleteFailedEngineException(this.shardId, delete2, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete2, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(delete2.uid());
        synchronized (object) {
            long updatedVersion;
            HashedBytesRef versionKey = this.versionKey(delete2.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete2.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (delete2.origin() == Engine.Operation.Origin.PRIMARY) {
                if (delete2.versionType() == VersionType.INTERNAL) {
                    if (delete2.version() != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, delete2.type(), delete2.id(), -1L, delete2.version());
                        }
                        if (delete2.version() != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, delete2.type(), delete2.id(), currentVersion, delete2.version());
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion != -1L && currentVersion >= delete2.version()) {
                        throw new VersionConflictEngineException(this.shardId, delete2.type(), delete2.id(), currentVersion, delete2.version());
                    }
                    updatedVersion = delete2.version();
                }
            } else {
                if (currentVersion != -2L && currentVersion != -1L && delete2.version() <= currentVersion) {
                    if (delete2.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, delete2.type(), delete2.id(), currentVersion - 1L, delete2.version());
                }
                updatedVersion = delete2.version();
            }
            if (currentVersion == -1L) {
                delete2.version(updatedVersion).notFound(true);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete2));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else if (versionValue != null && versionValue.delete()) {
                delete2.version(updatedVersion).notFound(true);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete2));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else {
                delete2.version(updatedVersion);
                writer.deleteDocuments(delete2.uid());
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete2));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            }
            this.indexingService.postDeleteUnderLock(delete2);
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete2) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId);
            }
            Query query = delete2.nested() && delete2.aliasFilter() != null ? new IncludeNestedDocsQuery((Query)new XFilteredQuery(delete2.query(), delete2.aliasFilter()), delete2.parentFilter()) : (delete2.nested() ? new IncludeNestedDocsQuery(delete2.query(), delete2.parentFilter()) : (delete2.aliasFilter() != null ? new XFilteredQuery(delete2.query(), delete2.aliasFilter()) : delete2.query()));
            writer.deleteDocuments(query);
            this.translog.add(new Translog.DeleteByQuery(delete2));
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteByQueryFailedEngineException(this.shardId, delete2, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.refreshVersioningTable(System.currentTimeMillis());
    }

    @Override
    public final Engine.Searcher acquireSearcher(String source) throws EngineException {
        SearcherManager manager = this.searcherManager;
        if (manager == null) {
            throw new EngineClosedException(this.shardId);
        }
        try {
            IndexSearcher searcher = (IndexSearcher)manager.acquire();
            return this.newSearcher(source, searcher, manager);
        }
        catch (Throwable ex) {
            this.logger.error("failed to acquire searcher, source {}", ex, source);
            throw new EngineException(this.shardId, "failed to acquire searcher", ex);
        }
    }

    protected Engine.Searcher newSearcher(String source, IndexSearcher searcher, SearcherManager manager) {
        return new RobinSearcher(source, searcher, manager);
    }

    @Override
    public boolean refreshNeeded() {
        return this.dirty;
    }

    @Override
    public boolean possibleMergeNeeded() {
        return this.possibleMergeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Engine.Refresh refresh) throws EngineException {
        block17: {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId);
            }
            this.rwl.readLock().lock();
            try {
                IndexWriter currentWriter = this.indexWriter;
                if (currentWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                try {
                    Object object = this.refreshMutex;
                    synchronized (object) {
                        if (this.dirty || refresh.force()) {
                            this.dirty = false;
                            this.searcherManager.maybeRefresh();
                        }
                    }
                }
                catch (AlreadyClosedException e) {
                }
                catch (OutOfMemoryError e) {
                    this.failEngine(e);
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("OutOfMemoryError")) {
                        this.failEngine(e);
                    }
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (Throwable e) {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    if (currentWriter != this.indexWriter) {
                        break block17;
                    }
                    throw new RefreshFailedEngineException(this.shardId, e);
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush(Engine.Flush flush2) throws EngineException {
        this.ensureOpen();
        if ((flush2.type() == Engine.Flush.Type.NEW_WRITER || flush2.type() == Engine.Flush.Type.COMMIT_TRANSLOG) && this.onGoingRecoveries.get() > 0) {
            throw new FlushNotAllowedEngineException(this.shardId, "recovery is in progress, flush [" + (Object)((Object)flush2.type()) + "] is not allowed");
        }
        int currentFlushing = this.flushing.incrementAndGet();
        if (currentFlushing > 1 && !flush2.waitIfOngoing()) {
            this.flushing.decrementAndGet();
            throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
        }
        this.flushLock.lock();
        try {
            block38: {
                if (flush2.type() == Engine.Flush.Type.NEW_WRITER) {
                    this.rwl.writeLock().lock();
                    try {
                        this.ensureOpen();
                        if (this.onGoingRecoveries.get() > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        this.dirty = false;
                        try {
                            this.indexWriter.close(false);
                            this.indexWriter = this.createWriter();
                            if (this.flushNeeded || flush2.force()) {
                                this.flushNeeded = false;
                                long translogId = this.translogIdGenerator.incrementAndGet();
                                this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                                this.indexWriter.commit();
                                this.translog.newTranslog(translogId);
                            }
                            SearcherManager current = this.searcherManager;
                            this.searcherManager = this.buildSearchManager(this.indexWriter);
                            try {
                                IOUtils.close(current);
                            }
                            catch (Throwable t) {
                                this.logger.warn("Failed to close current SearcherManager", t, new Object[0]);
                            }
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            break block38;
                        }
                        catch (OutOfMemoryError e) {
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Throwable e) {
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                    finally {
                        this.rwl.writeLock().unlock();
                    }
                }
                if (flush2.type() == Engine.Flush.Type.COMMIT_TRANSLOG) {
                    this.rwl.readLock().lock();
                    try {
                        this.ensureOpen();
                        if (this.onGoingRecoveries.get() > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        if (!this.flushNeeded && !flush2.force()) break block38;
                        this.flushNeeded = false;
                        try {
                            long translogId = this.translogIdGenerator.incrementAndGet();
                            this.translog.newTransientTranslog(translogId);
                            this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                            this.indexWriter.commit();
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            this.translog.makeTransientCurrent();
                            break block38;
                        }
                        catch (OutOfMemoryError e) {
                            this.translog.revertTransient();
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Throwable e) {
                            this.translog.revertTransient();
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                    finally {
                        this.rwl.readLock().unlock();
                    }
                }
                if (flush2.type() != Engine.Flush.Type.COMMIT) throw new ElasticSearchIllegalStateException("flush type [" + (Object)((Object)flush2.type()) + "] not supported");
                this.rwl.readLock().lock();
                try {
                    this.ensureOpen();
                    try {
                        long translogId = this.translog.currentId();
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                        this.indexWriter.commit();
                    }
                    catch (OutOfMemoryError e) {
                        this.translog.revertTransient();
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new FlushFailedEngineException(this.shardId, e);
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
            this.rwl.readLock().lock();
            try {
                this.ensureOpen();
                this.readLastCommittedSegmentsInfo();
                this.rwl.readLock().unlock();
                return;
            }
            catch (Throwable e) {
                try {
                    if (this.closed) return;
                    this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
        }
        finally {
            this.flushLock.unlock();
            this.flushing.decrementAndGet();
        }
    }

    private void ensureOpen() {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningTable(long time) {
        this.refresh(new Engine.Refresh("version_table").force(true));
        for (Map.Entry entry2 : this.versionMap.entrySet()) {
            HashedBytesRef uid = (HashedBytesRef)entry2.getKey();
            Object object = this.dirtyLock(uid.bytes);
            synchronized (object) {
                VersionValue versionValue = (VersionValue)this.versionMap.get(uid);
                if (versionValue == null) {
                    continue;
                }
                if (time - versionValue.time() <= 0L) {
                    continue;
                }
                if (versionValue.delete()) {
                    if (this.enableGcDeletes && time - versionValue.time() > this.gcDeletesInMillis) {
                        this.versionMap.remove(uid);
                    }
                } else {
                    this.versionMap.remove(uid);
                }
            }
        }
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded) {
            return;
        }
        this.possibleMergeNeeded = false;
        this.rwl.readLock().lock();
        try {
            this.ensureOpen();
            this.indexWriter.maybeMerge();
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (Throwable e) {
            throw new OptimizeFailedEngineException(this.shardId, e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws EngineException {
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true).waitIfOngoing(true));
        }
        if (this.optimizeMutex.compareAndSet(false, true)) {
            this.rwl.readLock().lock();
            try {
                this.ensureOpen();
                if (optimize.onlyExpungeDeletes()) {
                    this.indexWriter.forceMergeDeletes(false);
                } else if (optimize.maxNumSegments() <= 0) {
                    this.indexWriter.maybeMerge();
                    this.possibleMergeNeeded = false;
                } else {
                    this.indexWriter.forceMerge(optimize.maxNumSegments(), false);
                }
            }
            catch (OutOfMemoryError e) {
                this.failEngine(e);
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("OutOfMemoryError")) {
                    this.failEngine(e);
                }
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (Throwable e) {
                throw new OptimizeFailedEngineException(this.shardId, e);
            }
            finally {
                this.rwl.readLock().unlock();
                this.optimizeMutex.set(false);
            }
        }
        if (optimize.waitForMerge()) {
            this.indexWriter.waitForMerges();
        }
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true).waitIfOngoing(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        SnapshotIndexCommit snapshotIndexCommit = null;
        Translog.Snapshot traslogSnapshot = null;
        this.rwl.readLock().lock();
        try {
            snapshotIndexCommit = this.deletionPolicy.snapshot();
            traslogSnapshot = this.translog.snapshot();
        }
        catch (Throwable e) {
            if (snapshotIndexCommit != null) {
                snapshotIndexCommit.release();
            }
            throw new SnapshotFailedEngineException(this.shardId, e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        try {
            T t = snapshotHandler.snapshot(snapshotIndexCommit, traslogSnapshot);
            return t;
        }
        finally {
            snapshotIndexCommit.release();
            traslogSnapshot.release();
        }
    }

    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        this.rwl.readLock().lock();
        try {
            this.flush(new Engine.Flush().type(Engine.Flush.Type.COMMIT).waitIfOngoing(true));
            this.ensureOpen();
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        this.rwl.writeLock().lock();
        try {
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            this.onGoingRecoveries.increment();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Throwable e) {
            this.onGoingRecoveries.decrement();
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", e);
        }
        try {
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Throwable e2) {
            EngineClosedException e2;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            if (this.closed) {
                e2 = new EngineClosedException(this.shardId, e2);
            }
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", (Throwable)e2);
        }
        try {
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Throwable e3) {
            EngineClosedException e3;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            if (this.closed) {
                e3 = new EngineClosedException(this.shardId, e3);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", (Throwable)e3);
        }
        try {
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Throwable e4) {
            EngineClosedException e4;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (this.closed) {
                e4 = new EngineClosedException(this.shardId, e4);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", (Throwable)e4);
        }
        this.rwl.writeLock().lock();
        Translog.Snapshot phase3Snapshot = null;
        try {
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            recoveryHandler.phase3(phase3Snapshot);
        }
        catch (Throwable e) {
            throw new RecoveryEngineException(this.shardId, 3, "Execution failed", e);
        }
        finally {
            this.onGoingRecoveries.decrement();
            this.rwl.writeLock().unlock();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (phase3Snapshot != null) {
                phase3Snapshot.release();
            }
        }
    }

    private long getReaderRamBytesUsed(AtomicReaderContext reader) {
        assert (reader.reader() instanceof SegmentReader);
        return allowRamBytesUsed ? ((SegmentReader)reader.reader()).ramBytesUsed() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentsStats segmentsStats() {
        this.rwl.readLock().lock();
        try {
            SegmentsStats segmentsStats;
            this.ensureOpen();
            Engine.Searcher searcher = this.acquireSearcher("segments_stats");
            try {
                SegmentsStats stats = new SegmentsStats();
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    stats.add(1L, this.getReaderRamBytesUsed(reader));
                }
                segmentsStats = stats;
            }
            catch (Throwable throwable) {
                searcher.release();
                throw throwable;
            }
            searcher.release();
            return segmentsStats;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Segment> segments() {
        this.rwl.readLock().lock();
        try {
            Segment segment;
            this.ensureOpen();
            HashMap<String, Segment> segments = new HashMap<String, Segment>();
            Engine.Searcher searcher = this.acquireSearcher("segments");
            try {
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    assert (reader.reader() instanceof SegmentReader);
                    SegmentCommitInfo info = ((SegmentReader)reader.reader()).getSegmentInfo();
                    assert (!segments.containsKey(info.info.name));
                    segment = new Segment(info.info.name);
                    segment.search = true;
                    segment.docCount = reader.reader().numDocs();
                    segment.delDocCount = reader.reader().numDeletedDocs();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.info.name);
                    }
                    segment.memoryInBytes = this.getReaderRamBytesUsed(reader);
                    segments.put(info.info.name, segment);
                }
            }
            finally {
                searcher.release();
            }
            if (this.lastCommittedSegmentInfos != null) {
                SegmentInfos infos = this.lastCommittedSegmentInfos;
                for (SegmentCommitInfo info : infos) {
                    segment = (Segment)segments.get(info.info.name);
                    if (segment == null) {
                        segment = new Segment(info.info.name);
                        segment.search = false;
                        segment.committed = true;
                        segment.docCount = info.info.getDocCount();
                        segment.delDocCount = info.getDelCount();
                        segment.version = info.info.getVersion();
                        segment.compound = info.info.getUseCompoundFile();
                        try {
                            segment.sizeInBytes = info.sizeInBytes();
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get size for [{}]", e, info.info.name);
                        }
                        segments.put(info.info.name, segment);
                        continue;
                    }
                    segment.committed = true;
                }
            }
            Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
            Arrays.sort(segmentsArr, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return (int)(o1.getGeneration() - o2.getGeneration());
                }
            });
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block13: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment2 : segmentsArr) {
                        if (!segment2.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment2.mergeId = onGoingMerge.getId();
                        continue block13;
                    }
                }
            }
            List<Segment> list2 = Arrays.asList(segmentsArr);
            return list2;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticSearchException {
        this.rwl.writeLock().lock();
        try {
            this.innerClose();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            int ongoingRecoveries = this.onGoingRecoveries.awaitNoRecoveries(5000L);
            if (ongoingRecoveries > 0) {
                this.logger.debug("Waiting for ongoing recoveries timed out on close currently ongoing disoveries: [{}]", ongoingRecoveries);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failEngine(Throwable failure2) {
        Object object = this.failedEngineMutex;
        synchronized (object) {
            if (this.failedEngine != null) {
                return;
            }
            this.logger.warn("failed engine", failure2, new Object[0]);
            this.failedEngine = failure2;
            for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                listener.onFailedEngine(this.shardId, failure2);
            }
            this.innerClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        if (this.closed) {
            return;
        }
        this.indexSettingsService.removeListener(this.applySettings);
        this.closed = true;
        this.versionMap.clear();
        this.failedEngineListeners.clear();
        try {
            try {
                IOUtils.close(this.searcherManager);
            }
            catch (Throwable t) {
                this.logger.warn("Failed to close SearcherManager", t, new Object[0]);
            }
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            this.logger.debug("failed to rollback writer on close", e, new Object[0]);
        }
        finally {
            this.indexWriter = null;
        }
    }

    private HashedBytesRef versionKey(Term uid) {
        return new HashedBytesRef(uid.bytes());
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return this.dirtyLocks[Math.abs(hash) % this.dirtyLocks.length];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadCurrentVersionFromIndex(Term uid) {
        Engine.Searcher searcher = this.acquireSearcher("load_version");
        try {
            List<AtomicReaderContext> readers = searcher.reader().leaves();
            for (int i = 0; i < readers.size(); ++i) {
                AtomicReaderContext readerContext = readers.get(i);
                long version = UidField.loadVersion(readerContext, uid);
                if (version == -1L) continue;
                long l = version;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            searcher.release();
        }
    }

    private static boolean isMergedSegment(AtomicReader reader) {
        Map<String, String> diagnostics = ((SegmentReader)reader).getSegmentInfo().info.getDiagnostics();
        String source = diagnostics.get("source");
        assert (Arrays.asList("addIndexes(IndexReader...)", "flush", "merge").contains(source)) : "Unknown source " + source;
        return "merge".equals(source);
    }

    private IndexWriter createWriter() throws IOException {
        try {
            if (IndexWriter.isLocked(this.store.directory())) {
                this.logger.warn("shard is locked, releasing lock", new Object[0]);
                IndexWriter.unlock(this.store.directory());
            }
            boolean create2 = !Lucene.indexExists(this.store.directory());
            IndexWriterConfig config = new IndexWriterConfig(Lucene.VERSION, this.analysisService.defaultIndexAnalyzer());
            config.setOpenMode(create2 ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            config.setIndexDeletionPolicy(this.deletionPolicy);
            config.setMergeScheduler((MergeScheduler)this.mergeScheduler.newMergeScheduler());
            config.setMergePolicy((MergePolicy)this.mergePolicyProvider.newMergePolicy());
            config.setSimilarity(this.similarityService.similarity());
            config.setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            config.setMaxThreadStates(this.indexConcurrency);
            config.setCodec(this.codecService.codec(this.codecName));
            config.setWriteLockTimeout(5000L);
            config.setUseCompoundFile(this.compoundOnFlush);
            config.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                @Override
                public void warm(AtomicReader reader) throws IOException {
                    block5: {
                        try {
                            assert (RobinEngine.isMergedSegment(reader));
                            Engine.SimpleSearcher searcher = new Engine.SimpleSearcher("warmer", new IndexSearcher(reader));
                            IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(RobinEngine.this.shardId, searcher);
                            if (RobinEngine.this.warmer != null) {
                                RobinEngine.this.warmer.warm(context);
                            }
                        }
                        catch (Throwable t) {
                            if (!RobinEngine.this.closed) {
                                RobinEngine.this.logger.warn("Warm-up failed", t, new Object[0]);
                            }
                            if (!(t instanceof Error)) break block5;
                            throw (Error)t;
                        }
                    }
                }
            });
            return new IndexWriter(this.store.directory(), config);
        }
        catch (LockObtainFailedException ex) {
            boolean isLocked = IndexWriter.isLocked(this.store.directory());
            this.logger.warn("Could not lock IndexWriter isLocked [{}]", ex, isLocked);
            throw ex;
        }
    }

    private SearcherManager buildSearchManager(IndexWriter indexWriter) throws IOException {
        return new SearcherManager(indexWriter, true, this.searcherFactory);
    }

    static {
        assert (Version.CURRENT.luceneVersion == org.apache.lucene.util.Version.LUCENE_46) : "when upgrading to a new lucene version, check if ramBytes is fixed, see https://issues.apache.org/jira/browse/LUCENE-5373";
    }

    private static final class RecoveryCounter {
        private volatile int ongoingRecoveries = 0;

        private RecoveryCounter() {
        }

        synchronized void increment() {
            ++this.ongoingRecoveries;
        }

        synchronized void decrement() {
            --this.ongoingRecoveries;
            if (this.ongoingRecoveries == 0) {
                this.notifyAll();
            }
            assert (this.ongoingRecoveries >= 0) : "ongoingRecoveries must be >= 0 but was: " + this.ongoingRecoveries;
        }

        int get() {
            return this.ongoingRecoveries;
        }

        synchronized int awaitNoRecoveries(long timeout) throws InterruptedException {
            if (this.ongoingRecoveries > 0) {
                this.wait(timeout);
            }
            return this.ongoingRecoveries;
        }
    }

    class RobinSearchFactory
    extends SearcherFactory {
        RobinSearchFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexSearcher newSearcher(IndexReader reader) throws IOException {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(RobinEngine.this.similarityService.similarity());
            if (RobinEngine.this.warmer != null) {
                boolean closeNewSearcher;
                IndexSearcher newSearcher;
                block16: {
                    Releasable currentSearcher = null;
                    newSearcher = null;
                    closeNewSearcher = false;
                    try {
                        if (RobinEngine.this.searcherManager == null) {
                            newSearcher = searcher;
                        } else {
                            currentSearcher = RobinEngine.this.acquireSearcher("search_factory");
                            ArrayList<AtomicReader> readers = Lists.newArrayList();
                            for (AtomicReaderContext newReaderContext : searcher.getIndexReader().leaves()) {
                                if (RobinEngine.isMergedSegment(newReaderContext.reader())) continue;
                                boolean found = false;
                                for (AtomicReaderContext currentReaderContext : currentSearcher.reader().leaves()) {
                                    if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                readers.add(newReaderContext.reader());
                            }
                            if (!readers.isEmpty()) {
                                newSearcher = new IndexSearcher(new MultiReader(readers.toArray(new IndexReader[readers.size()]), false));
                                closeNewSearcher = true;
                            }
                        }
                        if (newSearcher != null) {
                            IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(RobinEngine.this.shardId, new Engine.SimpleSearcher("warmer", newSearcher));
                            RobinEngine.this.warmer.warm(context);
                        }
                        if (currentSearcher == null) break block16;
                    }
                    catch (Throwable e) {
                        block17: {
                            try {
                                if (!RobinEngine.this.closed) {
                                    RobinEngine.this.logger.warn("failed to prepare/warm", e, new Object[0]);
                                }
                                if (currentSearcher == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (currentSearcher != null) {
                                    currentSearcher.release();
                                }
                                if (newSearcher != null && closeNewSearcher) {
                                    IOUtils.closeWhileHandlingException(newSearcher.getIndexReader());
                                }
                                throw throwable;
                            }
                            currentSearcher.release();
                        }
                        if (newSearcher != null && closeNewSearcher) {
                            IOUtils.closeWhileHandlingException(newSearcher.getIndexReader());
                        }
                    }
                    currentSearcher.release();
                }
                if (newSearcher != null && closeNewSearcher) {
                    IOUtils.closeWhileHandlingException(newSearcher.getIndexReader());
                }
            }
            return searcher;
        }
    }

    static class VersionValue {
        private final long version;
        private final boolean delete;
        private final long time;
        private final Translog.Location translogLocation;

        VersionValue(long version, boolean delete2, long time, Translog.Location translogLocation) {
            this.version = version;
            this.delete = delete2;
            this.time = time;
            this.translogLocation = translogLocation;
        }

        public long time() {
            return this.time;
        }

        public long version() {
            return this.version;
        }

        public boolean delete() {
            return this.delete;
        }

        public Translog.Location translogLocation() {
            return this.translogLocation;
        }
    }

    static class RobinSearcher
    implements Engine.Searcher {
        private final String source;
        private final IndexSearcher searcher;
        private final SearcherManager manager;

        private RobinSearcher(String source, IndexSearcher searcher, SearcherManager manager) {
            this.source = source;
            this.searcher = searcher;
            this.manager = manager;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public boolean release() throws ElasticSearchException {
            try {
                this.manager.release(this.searcher);
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (AlreadyClosedException e) {
                return false;
            }
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compoundOnFlush;
            long gcDeletesInMillis = settings.getAsTime(RobinEngine.INDEX_GC_DELETES, TimeValue.timeValueMillis(RobinEngine.this.gcDeletesInMillis)).millis();
            if (gcDeletesInMillis != RobinEngine.this.gcDeletesInMillis) {
                RobinEngine.this.logger.info("updating index.gc_deletes from [{}] to [{}]", TimeValue.timeValueMillis(RobinEngine.this.gcDeletesInMillis), TimeValue.timeValueMillis(gcDeletesInMillis));
                RobinEngine.this.gcDeletesInMillis = gcDeletesInMillis;
            }
            if ((compoundOnFlush = settings.getAsBoolean(RobinEngine.INDEX_COMPOUND_ON_FLUSH, (Boolean)RobinEngine.this.compoundOnFlush).booleanValue()) != RobinEngine.this.compoundOnFlush) {
                RobinEngine.this.logger.info("updating {} from [{}] to [{}]", RobinEngine.INDEX_COMPOUND_ON_FLUSH, RobinEngine.this.compoundOnFlush, compoundOnFlush);
                RobinEngine.this.compoundOnFlush = compoundOnFlush;
                RobinEngine.this.indexWriter.getConfig().setUseCompoundFile(compoundOnFlush);
            }
            int indexConcurrency = settings.getAsInt(RobinEngine.INDEX_INDEX_CONCURRENCY, (Integer)RobinEngine.this.indexConcurrency);
            boolean failOnMergeFailure = settings.getAsBoolean(RobinEngine.INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)RobinEngine.this.failOnMergeFailure);
            String codecName = settings.get("index.codec", RobinEngine.this.codecName);
            boolean codecBloomLoad = settings.getAsBoolean("index.codec.bloom.load", (Boolean)RobinEngine.this.codecService.isLoadBloomFilter());
            boolean requiresFlushing = false;
            if (indexConcurrency != RobinEngine.this.indexConcurrency || !codecName.equals(RobinEngine.this.codecName) || failOnMergeFailure != RobinEngine.this.failOnMergeFailure || codecBloomLoad != RobinEngine.this.codecService.isLoadBloomFilter()) {
                RobinEngine.this.rwl.readLock().lock();
                try {
                    if (indexConcurrency != RobinEngine.this.indexConcurrency) {
                        RobinEngine.this.logger.info("updating index.index_concurrency from [{}] to [{}]", RobinEngine.this.indexConcurrency, indexConcurrency);
                        RobinEngine.this.indexConcurrency = indexConcurrency;
                        requiresFlushing = true;
                    }
                    if (!codecName.equals(RobinEngine.this.codecName)) {
                        RobinEngine.this.logger.info("updating index.codec from [{}] to [{}]", RobinEngine.this.codecName, codecName);
                        RobinEngine.this.codecName = codecName;
                        requiresFlushing = true;
                    }
                    if (failOnMergeFailure != RobinEngine.this.failOnMergeFailure) {
                        RobinEngine.this.logger.info("updating {} from [{}] to [{}]", RobinEngine.INDEX_FAIL_ON_MERGE_FAILURE, RobinEngine.this.failOnMergeFailure, failOnMergeFailure);
                        RobinEngine.this.failOnMergeFailure = failOnMergeFailure;
                    }
                    if (codecBloomLoad != RobinEngine.this.codecService.isLoadBloomFilter()) {
                        RobinEngine.this.logger.info("updating {} from [{}] to [{}]", "index.codec.bloom.load", RobinEngine.this.codecService.isLoadBloomFilter(), codecBloomLoad);
                        RobinEngine.this.codecService.setLoadBloomFilter(codecBloomLoad);
                        requiresFlushing = true;
                    }
                }
                finally {
                    RobinEngine.this.rwl.readLock().unlock();
                }
                if (requiresFlushing) {
                    RobinEngine.this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
            }
        }
    }

    class FailEngineOnMergeFailure
    implements MergeSchedulerProvider.FailureListener {
        FailEngineOnMergeFailure() {
        }

        @Override
        public void onFailedMerge(MergePolicy.MergeException e) {
            RobinEngine.this.failEngine(e);
        }
    }
}

