/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.codec.postingsformat.PostingFormats;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PreBuiltPostingsFormatProvider;
import org.elasticsearch.index.settings.IndexSettings;

public class PostingsFormatService
extends AbstractIndexComponent {
    private final ImmutableMap<String, PostingsFormatProvider> providers;
    public static final String DEFAULT_FORMAT = "default";

    public PostingsFormatService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public PostingsFormatService(Index index, @IndexSettings Settings indexSettings) {
        this(index, indexSettings, ImmutableMap.of());
    }

    @Inject
    public PostingsFormatService(Index index, @IndexSettings Settings indexSettings, Map<String, PostingsFormatProvider.Factory> postingFormatFactories) {
        super(index, indexSettings);
        MapBuilder<String, PostingsFormatProvider> providers = MapBuilder.newMapBuilder();
        Map<String, Settings> postingsFormatSettings = indexSettings.getGroups("index.codec.postings_format");
        for (Map.Entry<String, PostingsFormatProvider.Factory> entry2 : postingFormatFactories.entrySet()) {
            String name = entry2.getKey();
            PostingsFormatProvider.Factory factory = entry2.getValue();
            Settings settings = postingsFormatSettings.get(name);
            if (settings == null) {
                settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.create(name, settings));
        }
        for (PreBuiltPostingsFormatProvider.Factory factory : PostingFormats.listFactories()) {
            if (providers.containsKey(factory.name())) continue;
            providers.put(factory.name(), factory.get());
        }
        this.providers = providers.immutableMap();
    }

    public PostingsFormatProvider get(String name) throws ElasticSearchIllegalArgumentException {
        PostingsFormatProvider provider = this.providers.get(name);
        if (provider == null) {
            throw new ElasticSearchIllegalArgumentException("failed to find postings_format [" + name + "]");
        }
        return provider;
    }
}

