/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.util.Map;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;

public interface PostingsFormatProvider {
    public static final String POSTINGS_FORMAT_SETTINGS_PREFIX = "index.codec.postings_format";

    public PostingsFormat get();

    public String name();

    public static interface Factory {
        public PostingsFormatProvider create(String var1, Settings var2);
    }

    public static class Helper {
        public static PostingsFormatProvider lookup(@IndexSettings Settings indexSettings, String name, Map<String, Factory> postingFormatFactories) throws ElasticSearchIllegalArgumentException {
            Factory factory = postingFormatFactories.get(name);
            if (factory == null) {
                throw new ElasticSearchIllegalArgumentException("failed to find postings_format [" + name + "]");
            }
            Settings settings = indexSettings.getGroups(PostingsFormatProvider.POSTINGS_FORMAT_SETTINGS_PREFIX).get(name);
            if (settings == null) {
                settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            return factory.create(name, settings);
        }
    }
}

