/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.codecs.Codec;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;

public class CodecService
extends AbstractIndexComponent {
    public static final String INDEX_CODEC_BLOOM_LOAD = "index.codec.bloom.load";
    public static final boolean INDEX_CODEC_BLOOM_LOAD_DEFAULT = true;
    private final PostingsFormatService postingsFormatService;
    private final MapperService mapperService;
    private final ImmutableMap<String, Codec> codecs;
    private volatile boolean loadBloomFilter = true;
    public static final String DEFAULT_CODEC = "default";

    public CodecService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public CodecService(Index index, @IndexSettings Settings indexSettings) {
        this(index, indexSettings, new PostingsFormatService(index, indexSettings), null);
    }

    @Inject
    public CodecService(Index index, @IndexSettings Settings indexSettings, PostingsFormatService postingsFormatService, MapperService mapperService) {
        super(index, indexSettings);
        this.postingsFormatService = postingsFormatService;
        this.mapperService = mapperService;
        MapBuilder<String, Codec> codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put(DEFAULT_CODEC, Codec.getDefault());
        } else {
            codecs.put(DEFAULT_CODEC, new PerFieldMappingPostingFormatCodec(mapperService, postingsFormatService.get(DEFAULT_CODEC).get(), this.logger));
        }
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.immutableMap();
        this.loadBloomFilter = indexSettings.getAsBoolean(INDEX_CODEC_BLOOM_LOAD, (Boolean)true);
    }

    public PostingsFormatService postingsFormatService() {
        return this.postingsFormatService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public Codec codec(String name) throws ElasticSearchIllegalArgumentException {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new ElasticSearchIllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public boolean isLoadBloomFilter() {
        return this.loadBloomFilter;
    }

    public void setLoadBloomFilter(boolean loadBloomFilter) {
        this.loadBloomFilter = loadBloomFilter;
    }
}

