/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.codec.postingsformat.PostingFormats;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatService;
import org.elasticsearch.index.codec.postingsformat.PreBuiltPostingsFormatProvider;

public class CodecModule
extends AbstractModule {
    private final Settings indexSettings;
    private Map<String, Class<? extends PostingsFormatProvider>> customProviders = Maps.newHashMap();

    public CodecModule(Settings indexSettings) {
        this.indexSettings = indexSettings;
    }

    public CodecModule addPostingFormat(String name, Class<? extends PostingsFormatProvider> provider) {
        this.customProviders.put(name, provider);
        return this;
    }

    @Override
    protected void configure() {
        HashMap<String, Class<? extends PostingsFormatProvider>> postingFormatProviders = Maps.newHashMap(this.customProviders);
        Map<String, Settings> postingsFormatsSettings = this.indexSettings.getGroups("index.codec.postings_format");
        for (Map.Entry<String, Settings> entry2 : postingsFormatsSettings.entrySet()) {
            Class type;
            String name = entry2.getKey();
            Settings settings = entry2.getValue();
            String sType = settings.get("type");
            if (sType == null || sType.trim().isEmpty()) {
                throw new ElasticSearchIllegalArgumentException("PostingsFormat Factory [" + name + "] must have a type associated with it");
            }
            try {
                type = settings.getAsClass("type", null, "org.elasticsearch.index.codec.postingsformat.", "PostingsFormatProvider");
            }
            catch (NoClassSettingsException e) {
                throw new ElasticSearchIllegalArgumentException("The specified type [" + sType + "] for postingsFormat Factory [" + name + "] can't be found");
            }
            postingFormatProviders.put(name, type);
        }
        MapBinder<String, PostingsFormatProvider.Factory> postingFormatFactoryBinder = MapBinder.newMapBinder(this.binder(), String.class, PostingsFormatProvider.Factory.class);
        for (Map.Entry entry3 : postingFormatProviders.entrySet()) {
            postingFormatFactoryBinder.addBinding((String)entry3.getKey()).toProvider(FactoryProvider.newFactory(PostingsFormatProvider.Factory.class, (Class)entry3.getValue())).in(Scopes.SINGLETON);
        }
        for (PreBuiltPostingsFormatProvider.Factory factory : PostingFormats.listFactories()) {
            if (postingFormatProviders.containsKey(factory.name())) continue;
            postingFormatFactoryBinder.addBinding(factory.name()).toInstance(factory);
        }
        this.bind(PostingsFormatService.class).asEagerSingleton();
        this.bind(CodecService.class).asEagerSingleton();
    }
}

