/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;
import org.elasticsearch.index.shard.ShardId;

public class SimpleIdReaderCache
implements IdReaderCache {
    private final ImmutableMap<String, SimpleIdReaderTypeCache> types;
    @Nullable
    public final ShardId shardId;

    public SimpleIdReaderCache(ImmutableMap<String, SimpleIdReaderTypeCache> types, @Nullable ShardId shardId) {
        this.types = types;
        this.shardId = shardId;
    }

    @Override
    public IdReaderTypeCache type(String type) {
        return this.types.get(type);
    }

    @Override
    public HashedBytesArray parentIdByDoc(String type, int docId) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.parentIdByDoc(docId);
        }
        return null;
    }

    @Override
    public int docById(String type, HashedBytesArray id) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.docById(id);
        }
        return -1;
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes2 = 0L;
        for (SimpleIdReaderTypeCache readerTypeCache : this.types.values()) {
            sizeInBytes2 += readerTypeCache.sizeInBytes();
        }
        return sizeInBytes2;
    }

    public HashedBytesArray canReuse(HashedBytesArray id) {
        for (SimpleIdReaderTypeCache typeCache : this.types.values()) {
            HashedBytesArray wrap2 = typeCache.canReuse(id);
            if (wrap2 == null) continue;
            return wrap2;
        }
        return null;
    }
}

