/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.UTF8SortedAsUnicodeComparator;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;

public class SimpleIdCache
extends AbstractIndexComponent
implements IdCache,
SegmentReader.CoreClosedListener {
    private final ConcurrentMap<Object, SimpleIdReaderCache> idReaders = ConcurrentCollections.newConcurrentMap();
    private final boolean reuse = this.componentSettings.getAsBoolean("reuse", (Boolean)false);
    IndexService indexService;

    @Inject
    public SimpleIdCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        Iterator it = this.idReaders.values().iterator();
        while (it.hasNext()) {
            SimpleIdReaderCache idReaderCache = (SimpleIdReaderCache)it.next();
            it.remove();
            this.onRemoval(idReaderCache);
        }
    }

    @Override
    public void onClose(Object coreCacheKey) {
        this.clear(coreCacheKey);
    }

    @Override
    public void clear(Object coreCacheKey) {
        SimpleIdReaderCache removed = (SimpleIdReaderCache)this.idReaders.remove(coreCacheKey);
        if (removed != null) {
            this.onRemoval(removed);
        }
    }

    @Override
    public IdReaderCache reader(AtomicReader reader) {
        return (IdReaderCache)this.idReaders.get(reader.getCoreCacheKey());
    }

    @Override
    public Iterator<IdReaderCache> iterator() {
        return (Iterator)((Object)this.idReaders.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void refresh(List<AtomicReaderContext> atomicReaderContexts) throws IOException {
        block23: {
            if (!this.refreshNeeded(atomicReaderContexts)) break block23;
            var2_2 = this.idReaders;
            synchronized (var2_2) {
                if (!this.refreshNeeded(atomicReaderContexts)) {
                    return;
                }
                builders = new HashMap<Object, Map<String, TypeBuilder>>();
                cacheToReader = new HashMap<Object, AtomicReader>();
                parentTypes = new TreeSet<BytesReference>(UTF8SortedAsUnicodeComparator.utf8SortedAsUnicodeSortOrder);
                spare = new BytesRef();
                for (String type : this.indexService.mapperService().types()) {
                    parentFieldMapper = this.indexService.mapperService().documentMapper(type).parentFieldMapper();
                    if (!parentFieldMapper.active()) continue;
                    parentTypes.add(new HashedBytesArray(Strings.toUTF8Bytes(parentFieldMapper.type(), spare)));
                }
                block4: for (AtomicReaderContext context : atomicReaderContexts) {
                    reader = context.reader();
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    if (reader instanceof SegmentReader) {
                        ((SegmentReader)reader).addCoreClosedListener(this);
                    }
                    readerBuilder = new HashMap<K, V>();
                    builders.put(reader.getCoreCacheKey(), readerBuilder);
                    cacheToReader.put(reader.getCoreCacheKey(), context.reader());
                    terms = reader.terms(UidFieldMapper.NAME);
                    if (terms == null) continue;
                    termsEnum = terms.iterator(null);
                    docsEnum = null;
                    term = termsEnum.next();
                    block5: while (term != null) {
                        typeAndId = Uid.splitUidIntoTypeAndId(term);
                        if (parentTypes.contains(typeAndId[0])) ** GOTO lbl46
                        while ((nextParent = (HashedBytesArray)parentTypes.ceiling(typeAndId[0])) != null && (status = termsEnum.seekCeil(nextParent.toBytesRef())) != TermsEnum.SeekStatus.END) {
                            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                                term = termsEnum.term();
                                typeAndId = Uid.splitUidIntoTypeAndId(term);
                            } else if (status == TermsEnum.SeekStatus.FOUND) {
                                if (!SimpleIdCache.$assertionsDisabled) {
                                    throw new AssertionError((Object)"Seek status should never be FOUND, because we seek only the type part");
                                }
                                term = termsEnum.term();
                                typeAndId = Uid.splitUidIntoTypeAndId(term);
                            }
                            if (!parentTypes.contains(typeAndId[0])) continue;
lbl46:
                            // 2 sources

                            if ((typeBuilder = (TypeBuilder)readerBuilder.get(type = typeAndId[0].toUtf8())) == null) {
                                typeBuilder = new TypeBuilder(reader);
                                readerBuilder.put(type, typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, typeAndId[1]);
                            docsEnum = termsEnum.docs(null, docsEnum, 0);
                            docId = docsEnum.nextDoc();
                            while (docId != 0x7FFFFFFF) {
                                typeBuilder.idToDoc.put(idAsBytes, docId);
                                typeBuilder.docToId[docId] = idAsBytes;
                                docId = docsEnum.nextDoc();
                            }
                            term = termsEnum.next();
                            continue block5;
                        }
                        continue block4;
                    }
                }
                for (AtomicReaderContext context : atomicReaderContexts) {
                    reader = context.reader();
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    readerBuilder = (Map)builders.get(reader.getCoreCacheKey());
                    terms = reader.terms("_parent");
                    if (terms == null) continue;
                    termsEnum = terms.iterator(null);
                    docsEnum = null;
                    term = termsEnum.next();
                    while (term != null) {
                        typeAndId = Uid.splitUidIntoTypeAndId(term);
                        typeBuilder = (TypeBuilder)readerBuilder.get(typeAndId[0].toUtf8());
                        if (typeBuilder == null) {
                            typeBuilder = new TypeBuilder(reader);
                            readerBuilder.put(typeAndId[0].toUtf8(), typeBuilder);
                        }
                        idAsBytes = this.checkIfCanReuse(builders, typeAndId[1]);
                        added = false;
                        docsEnum = termsEnum.docs(null, docsEnum, 0);
                        docId = docsEnum.nextDoc();
                        while (docId != 0x7FFFFFFF) {
                            if (!added) {
                                typeBuilder.parentIdsValues.add(idAsBytes);
                                added = true;
                            }
                            typeBuilder.parentIdsOrdinals[docId] = typeBuilder.t;
                            docId = docsEnum.nextDoc();
                        }
                        if (added) {
                            ++typeBuilder.t;
                        }
                        term = termsEnum.next();
                    }
                }
                for (Map.Entry entry : builders.entrySet()) {
                    readerKey = entry.getKey();
                    types = MapBuilder.newMapBuilder();
                    for (Map.Entry<K, V> typeBuilderEntry : ((Map)entry.getValue()).entrySet()) {
                        types.put(typeBuilderEntry.getKey(), new SimpleIdReaderTypeCache((String)typeBuilderEntry.getKey(), ((TypeBuilder)typeBuilderEntry.getValue()).idToDoc, ((TypeBuilder)typeBuilderEntry.getValue()).docToId, ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.toArray(new HashedBytesArray[((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.size()]), ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsOrdinals));
                    }
                    indexReader = (IndexReader)cacheToReader.get(readerKey);
                    readerCache = new SimpleIdReaderCache(types.immutableMap(), ShardUtils.extractShardId(indexReader));
                    this.idReaders.put(readerKey, readerCache);
                    this.onCached(readerCache);
                }
            }
        }
    }

    void onCached(SimpleIdReaderCache readerCache) {
        IndexShard shard;
        if (readerCache.shardId != null && (shard = this.indexService.shard(readerCache.shardId.id())) != null) {
            shard.idCache().onCached(readerCache.sizeInBytes());
        }
    }

    void onRemoval(SimpleIdReaderCache readerCache) {
        IndexShard shard;
        if (readerCache.shardId != null && (shard = this.indexService.shard(readerCache.shardId.id())) != null) {
            shard.idCache().onRemoval(readerCache.sizeInBytes());
        }
    }

    private HashedBytesArray checkIfCanReuse(Map<Object, Map<String, TypeBuilder>> builders, HashedBytesArray idAsBytes) {
        HashedBytesArray finalIdAsBytes;
        if (this.reuse) {
            for (SimpleIdReaderCache idReaderCache : this.idReaders.values()) {
                finalIdAsBytes = idReaderCache.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        for (Map<String, TypeBuilder> map2 : builders.values()) {
            for (TypeBuilder typeBuilder : map2.values()) {
                finalIdAsBytes = typeBuilder.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        return idAsBytes;
    }

    private boolean refreshNeeded(List<AtomicReaderContext> atomicReaderContexts) {
        for (AtomicReaderContext atomicReaderContext : atomicReaderContexts) {
            if (this.idReaders.containsKey(atomicReaderContext.reader().getCoreCacheKey())) continue;
            return true;
        }
        return false;
    }

    static class TypeBuilder {
        final ObjectIntOpenHashMap<HashedBytesArray> idToDoc = new ObjectIntOpenHashMap();
        final HashedBytesArray[] docToId;
        final ArrayList<HashedBytesArray> parentIdsValues = new ArrayList();
        final int[] parentIdsOrdinals;
        int t = 1;

        TypeBuilder(IndexReader reader) {
            this.parentIdsOrdinals = new int[reader.maxDoc()];
            this.parentIdsValues.add(null);
            this.docToId = new HashedBytesArray[reader.maxDoc()];
        }

        public HashedBytesArray canReuse(HashedBytesArray id) {
            if (this.idToDoc.containsKey(id)) {
                return this.idToDoc.lkey();
            }
            return id;
        }
    }
}

