/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.docset.DocSetCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.settings.IndexSettings;

public class IndexCache
extends AbstractIndexComponent
implements CloseableComponent,
ClusterStateListener {
    private final FilterCache filterCache;
    private final QueryParserCache queryParserCache;
    private final IdCache idCache;
    private final DocSetCache docSetCache;
    private ClusterService clusterService;

    @Inject
    public IndexCache(Index index, @IndexSettings Settings indexSettings, FilterCache filterCache, QueryParserCache queryParserCache, IdCache idCache, DocSetCache docSetCache) {
        super(index, indexSettings);
        this.filterCache = filterCache;
        this.queryParserCache = queryParserCache;
        this.idCache = idCache;
        this.docSetCache = docSetCache;
    }

    @Inject(optional=true)
    public void setClusterService(@Nullable ClusterService clusterService) {
        this.clusterService = clusterService;
        if (clusterService != null) {
            clusterService.add(this);
        }
    }

    public FilterCache filter() {
        return this.filterCache;
    }

    public DocSetCache docSet() {
        return this.docSetCache;
    }

    public IdCache idCache() {
        return this.idCache;
    }

    public QueryParserCache queryParserCache() {
        return this.queryParserCache;
    }

    @Override
    public void close() throws ElasticSearchException {
        this.filterCache.close();
        this.idCache.close();
        this.queryParserCache.close();
        this.docSetCache.clear("close");
        if (this.clusterService != null) {
            this.clusterService.remove(this);
        }
    }

    public void clear(IndexReader reader) {
        this.filterCache.clear(reader);
        this.idCache.clear(reader);
        this.docSetCache.clear(reader);
    }

    public void clear(String reason) {
        this.filterCache.clear(reason);
        this.idCache.clear();
        this.queryParserCache.clear();
        this.docSetCache.clear(reason);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.metaDataChanged()) {
            this.queryParserCache.clear();
        }
    }
}

