/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class TrimTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean updateOffsets;
    private static final String UPDATE_OFFSETS_KEY = "update_offsets";

    @Inject
    public TrimTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        if (this.version.onOrAfter(Version.LUCENE_44) && settings.get(UPDATE_OFFSETS_KEY) != null) {
            throw new ElasticSearchIllegalArgumentException("update_offsets is not supported anymore. Please fix your analysis chain or use an older compatibility version (<=4.3) but beware that it might cause highlighting bugs.");
        }
        this.updateOffsets = settings.getAsBoolean(UPDATE_OFFSETS_KEY, (Boolean)false);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_44)) {
            return new TrimFilter(this.version, tokenStream);
        }
        return new TrimFilter(this.version, tokenStream, this.updateOffsets);
    }
}

