/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;

public class PreBuiltTokenizerFactoryFactory
implements TokenizerFactoryFactory {
    private final TokenizerFactory tokenizerFactory;

    public PreBuiltTokenizerFactoryFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public TokenizerFactory create(String name, Settings settings) {
        Version indexVersion = settings.getAsVersion("index.version.created", Version.CURRENT);
        if (!Version.CURRENT.equals(indexVersion)) {
            TokenizerFactory versionedTokenizerFactory = PreBuiltTokenizers.valueOf(name.toUpperCase(Locale.ROOT)).getTokenizerFactory(indexVersion);
            return versionedTokenizerFactory;
        }
        return this.tokenizerFactory;
    }
}

