/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;

public class PreBuiltTokenFilterFactoryFactory
implements TokenFilterFactoryFactory {
    private final TokenFilterFactory tokenFilterFactory;

    public PreBuiltTokenFilterFactoryFactory(TokenFilterFactory tokenFilterFactory) {
        this.tokenFilterFactory = tokenFilterFactory;
    }

    @Override
    public TokenFilterFactory create(String name, Settings settings) {
        Version indexVersion = settings.getAsVersion("index.version.created", Version.CURRENT);
        if (!Version.CURRENT.equals(indexVersion)) {
            return PreBuiltTokenFilters.valueOf(name.toUpperCase(Locale.ROOT)).getTokenFilterFactory(indexVersion);
        }
        return this.tokenFilterFactory;
    }
}

