/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactoryFactory;
import org.elasticsearch.indices.analysis.PreBuiltCharFilters;

public class PreBuiltCharFilterFactoryFactory
implements CharFilterFactoryFactory {
    private final CharFilterFactory charFilterFactory;

    public PreBuiltCharFilterFactoryFactory(CharFilterFactory charFilterFactory) {
        this.charFilterFactory = charFilterFactory;
    }

    @Override
    public CharFilterFactory create(String name, Settings settings) {
        Version indexVersion = settings.getAsVersion("index.version.created", Version.CURRENT);
        if (!Version.CURRENT.equals(indexVersion)) {
            return PreBuiltCharFilters.valueOf(name.toUpperCase(Locale.ROOT)).getCharFilterFactory(indexVersion);
        }
        return this.charFilterFactory;
    }
}

