/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerProviderFactory;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProvider;
import org.elasticsearch.indices.analysis.PreBuiltAnalyzers;

public class PreBuiltAnalyzerProviderFactory
implements AnalyzerProviderFactory {
    private final PreBuiltAnalyzerProvider analyzerProvider;

    public PreBuiltAnalyzerProviderFactory(String name, AnalyzerScope scope, Analyzer analyzer) {
        this.analyzerProvider = new PreBuiltAnalyzerProvider(name, scope, analyzer);
    }

    @Override
    public AnalyzerProvider create(String name, Settings settings) {
        Version indexVersion = settings.getAsVersion("index.version.created", Version.CURRENT);
        if (!Version.CURRENT.equals(indexVersion)) {
            Analyzer analyzer = PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT)).getAnalyzer(indexVersion);
            return new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, analyzer);
        }
        return this.analyzerProvider;
    }

    public Analyzer analyzer() {
        return this.analyzerProvider.get();
    }
}

