/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class KeepWordFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keepWords;
    private final boolean enablePositionIncrements;
    private static final String KEEP_WORDS_KEY = "keep_words";
    private static final String KEEP_WORDS_PATH_KEY = "keep_words_path";
    private static final String KEEP_WORDS_CASE_KEY = "keep_words_case";
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    @Inject
    public KeepWordFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String[] arrayKeepWords = settings.getAsArray(KEEP_WORDS_KEY, null);
        String keepWordsPath = settings.get(KEEP_WORDS_PATH_KEY, null);
        if (arrayKeepWords == null && keepWordsPath == null || arrayKeepWords != null && keepWordsPath != null) {
            throw new ElasticSearchIllegalArgumentException("keep requires either `keep_words` or `keep_words_path` to be configured");
        }
        if (this.version.onOrAfter(Version.LUCENE_44) && settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new ElasticSearchIllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain or use an older compatibility version (<=4.3) but beware that it might cause highlighting bugs.");
        }
        this.enablePositionIncrements = this.version.onOrAfter(Version.LUCENE_44) ? true : settings.getAsBoolean(ENABLE_POS_INC_KEY, (Boolean)true);
        this.keepWords = Analysis.getWordSet(env, settings, KEEP_WORDS_KEY, this.version);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_44)) {
            return new KeepWordFilter(this.version, tokenStream, this.keepWords);
        }
        return new KeepWordFilter(this.version, this.enablePositionIncrements, tokenStream, this.keepWords);
    }
}

