/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.settings.IndexSettings;

public class Analysis {
    public static final ImmutableMap<String, Set<?>> namedStopWords = MapBuilder.newMapBuilder().put("_arabic_", ArabicAnalyzer.getDefaultStopSet()).put("_armenian_", ArmenianAnalyzer.getDefaultStopSet()).put("_basque_", BasqueAnalyzer.getDefaultStopSet()).put("_brazilian_", BrazilianAnalyzer.getDefaultStopSet()).put("_bulgarian_", BulgarianAnalyzer.getDefaultStopSet()).put("_catalan_", CatalanAnalyzer.getDefaultStopSet()).put("_czech_", CzechAnalyzer.getDefaultStopSet()).put("_danish_", DanishAnalyzer.getDefaultStopSet()).put("_dutch_", DutchAnalyzer.getDefaultStopSet()).put("_english_", EnglishAnalyzer.getDefaultStopSet()).put("_finnish_", FinnishAnalyzer.getDefaultStopSet()).put("_french_", FrenchAnalyzer.getDefaultStopSet()).put("_galician_", GalicianAnalyzer.getDefaultStopSet()).put("_german_", GermanAnalyzer.getDefaultStopSet()).put("_greek_", GreekAnalyzer.getDefaultStopSet()).put("_hindi_", HindiAnalyzer.getDefaultStopSet()).put("_hungarian_", HungarianAnalyzer.getDefaultStopSet()).put("_indonesian_", IndonesianAnalyzer.getDefaultStopSet()).put("_italian_", ItalianAnalyzer.getDefaultStopSet()).put("_norwegian_", NorwegianAnalyzer.getDefaultStopSet()).put("_persian_", PersianAnalyzer.getDefaultStopSet()).put("_portuguese_", PortugueseAnalyzer.getDefaultStopSet()).put("_romanian_", RomanianAnalyzer.getDefaultStopSet()).put("_russian_", RussianAnalyzer.getDefaultStopSet()).put("_spanish_", SpanishAnalyzer.getDefaultStopSet()).put("_swedish_", SwedishAnalyzer.getDefaultStopSet()).put("_turkish_", TurkishAnalyzer.getDefaultStopSet()).immutableMap();

    public static org.apache.lucene.util.Version parseAnalysisVersion(@IndexSettings Settings indexSettings, Settings settings, ESLogger logger) {
        String sVersion = settings.get("version");
        if (sVersion != null) {
            return Lucene.parseVersion(sVersion, Lucene.ANALYZER_VERSION, logger);
        }
        sVersion = indexSettings.get("index.analysis.version");
        if (sVersion != null) {
            return Lucene.parseVersion(sVersion, Lucene.ANALYZER_VERSION, logger);
        }
        return indexSettings.getAsVersion((String)"index.version.created", (Version)Version.CURRENT).luceneVersion;
    }

    public static boolean isNoStopwords(Settings settings) {
        String value2 = settings.get("stopwords");
        return value2 != null && "_none_".equals(value2);
    }

    public static CharArraySet parseStemExclusion(Settings settings, CharArraySet defaultStemExclusion, org.apache.lucene.util.Version version) {
        String value2 = settings.get("stem_exclusion");
        if (value2 != null) {
            if ("_none_".equals(value2)) {
                return CharArraySet.EMPTY_SET;
            }
            return new CharArraySet(version, Strings.commaDelimitedListToSet(value2), false);
        }
        String[] stopWords = settings.getAsArray("stem_exclusion", null);
        if (stopWords != null) {
            return new CharArraySet(version, ImmutableList.of(stopWords), false);
        }
        return defaultStemExclusion;
    }

    public static CharArraySet parseWords(Environment env, Settings settings, String name, CharArraySet defaultWords, ImmutableMap<String, Set<?>> namedWords, org.apache.lucene.util.Version version, boolean ignoreCase) {
        String value2 = settings.get(name);
        if (value2 != null) {
            if ("_none_".equals(value2)) {
                return CharArraySet.EMPTY_SET;
            }
            return Analysis.resolveNamedWords(Strings.commaDelimitedListToSet(value2), namedWords, version, ignoreCase);
        }
        List<String> pathLoadedWords = Analysis.getWordList(env, settings, name);
        if (pathLoadedWords != null) {
            return Analysis.resolveNamedWords(pathLoadedWords, namedWords, version, ignoreCase);
        }
        return defaultWords;
    }

    public static CharArraySet parseCommonWords(Environment env, Settings settings, CharArraySet defaultCommonWords, org.apache.lucene.util.Version version, boolean ignoreCase) {
        return Analysis.parseWords(env, settings, "common_words", defaultCommonWords, namedStopWords, version, ignoreCase);
    }

    public static CharArraySet parseArticles(Environment env, Settings settings, org.apache.lucene.util.Version version) {
        return Analysis.parseWords(env, settings, "articles", null, null, version, settings.getAsBoolean("articles_case", (Boolean)false));
    }

    public static CharArraySet parseStopWords(Environment env, Settings settings, CharArraySet defaultStopWords, org.apache.lucene.util.Version version) {
        return Analysis.parseStopWords(env, settings, defaultStopWords, version, settings.getAsBoolean("stopwords_case", (Boolean)false));
    }

    public static CharArraySet parseStopWords(Environment env, Settings settings, CharArraySet defaultStopWords, org.apache.lucene.util.Version version, boolean ignoreCase) {
        return Analysis.parseWords(env, settings, "stopwords", defaultStopWords, namedStopWords, version, ignoreCase);
    }

    private static CharArraySet resolveNamedWords(Collection<String> words, ImmutableMap<String, Set<?>> namedWords, org.apache.lucene.util.Version version, boolean ignoreCase) {
        if (namedWords == null) {
            return new CharArraySet(version, words, ignoreCase);
        }
        CharArraySet setWords = new CharArraySet(version, words.size(), ignoreCase);
        for (String word : words) {
            if (namedWords.containsKey(word)) {
                setWords.addAll((Collection)namedWords.get(word));
                continue;
            }
            setWords.add(word);
        }
        return setWords;
    }

    public static CharArraySet getWordSet(Environment env, Settings settings, String settingsPrefix, org.apache.lucene.util.Version version) {
        List<String> wordList = Analysis.getWordList(env, settings, settingsPrefix);
        if (wordList == null) {
            return null;
        }
        return new CharArraySet(version, wordList, (boolean)settings.getAsBoolean(settingsPrefix + "_case", (Boolean)false));
    }

    public static List<String> getWordList(Environment env, Settings settings, String settingPrefix) {
        String wordListPath = settings.get(settingPrefix + "_path", null);
        if (wordListPath == null) {
            String[] explicitWordList = settings.getAsArray(settingPrefix, null);
            if (explicitWordList == null) {
                return null;
            }
            return Arrays.asList(explicitWordList);
        }
        URL wordListFile = env.resolveConfig(wordListPath);
        try {
            return Analysis.loadWordList(new InputStreamReader(wordListFile.openStream(), Charsets.UTF_8), "#");
        }
        catch (IOException ioe) {
            String message = String.format(Locale.ROOT, "IOException while reading %s_path: %s", settingPrefix, ioe.getMessage());
            throw new ElasticSearchIllegalArgumentException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadWordList(Reader reader, String comment2) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String word = null;
            while ((word = br.readLine()) != null) {
                if (!Strings.hasText(word) || word.startsWith(comment2)) continue;
                result2.add(word.trim());
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result2;
    }

    public static Reader getReaderFromFile(Environment env, Settings settings, String settingPrefix) {
        String filePath = settings.get(settingPrefix, null);
        if (filePath == null) {
            return null;
        }
        URL fileUrl = env.resolveConfig(filePath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fileUrl.openStream(), Charsets.UTF_8);
        }
        catch (IOException ioe) {
            String message = String.format(Locale.ROOT, "IOException while reading %s_path: %s", settingPrefix, ioe.getMessage());
            throw new ElasticSearchIllegalArgumentException(message);
        }
        return reader;
    }

    public static boolean isCharacterTokenStream(TokenStream tokenStream) {
        try {
            tokenStream.addAttribute(CharTermAttribute.class);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean generatesCharacterTokenStream(Analyzer analyzer, String fieldName) throws IOException {
        return Analysis.isCharacterTokenStream(analyzer.tokenStream(fieldName, ""));
    }
}

