/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ChannelBufferBytesReference;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.RestUtils;

public class NettyHttpRequest
extends HttpRequest {
    private final org.elasticsearch.common.netty.handler.codec.http.HttpRequest request;
    private final Channel channel;
    private final Map<String, String> params;
    private final String rawPath;
    private final BytesReference content;

    public NettyHttpRequest(org.elasticsearch.common.netty.handler.codec.http.HttpRequest request, Channel channel) {
        this.request = request;
        this.channel = channel;
        this.params = new HashMap<String, String>();
        this.content = request.getContent().readable() ? new ChannelBufferBytesReference(request.getContent()) : BytesArray.EMPTY;
        String uri = request.getUri();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString(uri, pathEndPos + 1, this.params);
        }
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public boolean hasContent() {
        return this.content.length() > 0;
    }

    @Override
    public boolean contentUnsafe() {
        return false;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public String header(String name) {
        return this.request.headers().get(name);
    }

    @Override
    public Iterable<Map.Entry<String, String>> headers() {
        return this.request.headers().entries();
    }

    @Override
    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public String param(String key, String defaultValue) {
        String value2 = this.params.get(key);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }
}

