/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.handler.codec.http.Cookie;
import org.elasticsearch.common.netty.handler.codec.http.CookieDecoder;
import org.elasticsearch.common.netty.handler.codec.http.CookieEncoder;
import org.elasticsearch.common.netty.handler.codec.http.DefaultHttpResponse;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponseStatus;
import org.elasticsearch.common.netty.handler.codec.http.HttpVersion;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpException;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.support.RestUtils;

public class NettyHttpChannel
implements HttpChannel {
    private final NettyHttpServerTransport transport;
    private final Channel channel;
    private final HttpRequest request;

    public NettyHttpChannel(NettyHttpServerTransport transport, Channel channel, HttpRequest request) {
        this.transport = transport;
        this.channel = channel;
        this.request = request;
    }

    @Override
    public void sendResponse(RestResponse response) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        String cookieString;
        ChannelBuffer buf;
        Map<String, List<String>> customHeaders;
        String opaque;
        DefaultHttpResponse resp;
        boolean http10 = this.request.getProtocolVersion().equals(HttpVersion.HTTP_1_0);
        boolean close2 = "close".equalsIgnoreCase(this.request.headers().get("Connection")) || http10 && !"keep-alive".equalsIgnoreCase(this.request.headers().get("Connection"));
        HttpResponseStatus status = this.getStatus(response.status());
        if (http10) {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_0, status);
            if (!close2) {
                resp.headers().add("Connection", "Keep-Alive");
            }
        } else {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        if (RestUtils.isBrowser(this.request.headers().get("User-Agent")) && this.transport.settings().getAsBoolean("http.cors.enabled", (Boolean)true).booleanValue()) {
            resp.headers().add("Access-Control-Allow-Origin", this.transport.settings().get("http.cors.allow-origin", "*"));
            if (this.request.getMethod() == HttpMethod.OPTIONS) {
                resp.headers().add("Access-Control-Max-Age", this.transport.settings().getAsInt("http.cors.max-age", (Integer)1728000));
                resp.headers().add("Access-Control-Allow-Methods", this.transport.settings().get("http.cors.allow-methods", "OPTIONS, HEAD, GET, POST, PUT, DELETE"));
                resp.headers().add("Access-Control-Allow-Headers", this.transport.settings().get("http.cors.allow-headers", "X-Requested-With, Content-Type, Content-Length"));
            }
        }
        if ((opaque = this.request.headers().get("X-Opaque-Id")) != null) {
            resp.headers().add("X-Opaque-Id", opaque);
        }
        if ((customHeaders = response.getHeaders()) != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    resp.headers().add(headerEntry.getKey(), headerValue);
                }
            }
        }
        try {
            if (response instanceof XContentRestResponse) {
                XContentBuilder builder = ((XContentRestResponse)response).builder();
                buf = response.contentThreadSafe() ? builder.bytes().toChannelBuffer() : builder.bytes().copyBytesArray().toChannelBuffer();
            } else {
                buf = response.contentThreadSafe() ? ChannelBuffers.wrappedBuffer(response.content(), response.contentOffset(), response.contentLength()) : ChannelBuffers.copiedBuffer(response.content(), response.contentOffset(), response.contentLength());
            }
        }
        catch (IOException e) {
            throw new HttpException("Failed to convert response to bytes", e);
        }
        if (response.prefixContent() != null || response.suffixContent() != null) {
            ChannelBuffer prefixBuf = ChannelBuffers.EMPTY_BUFFER;
            if (response.prefixContent() != null) {
                prefixBuf = ChannelBuffers.copiedBuffer(response.prefixContent(), response.prefixContentOffset(), response.prefixContentLength());
            }
            ChannelBuffer suffixBuf = ChannelBuffers.EMPTY_BUFFER;
            if (response.suffixContent() != null) {
                suffixBuf = ChannelBuffers.copiedBuffer(response.suffixContent(), response.suffixContentOffset(), response.suffixContentLength());
            }
            buf = ChannelBuffers.wrappedBuffer(prefixBuf, buf, suffixBuf);
        }
        resp.setContent(buf);
        resp.headers().add("Content-Type", response.contentType());
        resp.headers().add("Content-Length", String.valueOf(buf.readableBytes()));
        if (this.transport.resetCookies && (cookieString = this.request.headers().get("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            resp.headers().add("Set-Cookie", cookieEncoder.encode());
        }
        ChannelFuture future = this.channel.write(resp);
        if (close2) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private HttpResponseStatus getStatus(RestStatus status) {
        switch (status) {
            case CONTINUE: {
                return HttpResponseStatus.CONTINUE;
            }
            case SWITCHING_PROTOCOLS: {
                return HttpResponseStatus.SWITCHING_PROTOCOLS;
            }
            case OK: {
                return HttpResponseStatus.OK;
            }
            case CREATED: {
                return HttpResponseStatus.CREATED;
            }
            case ACCEPTED: {
                return HttpResponseStatus.ACCEPTED;
            }
            case NON_AUTHORITATIVE_INFORMATION: {
                return HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION;
            }
            case NO_CONTENT: {
                return HttpResponseStatus.NO_CONTENT;
            }
            case RESET_CONTENT: {
                return HttpResponseStatus.RESET_CONTENT;
            }
            case PARTIAL_CONTENT: {
                return HttpResponseStatus.PARTIAL_CONTENT;
            }
            case MULTI_STATUS: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case MULTIPLE_CHOICES: {
                return HttpResponseStatus.MULTIPLE_CHOICES;
            }
            case MOVED_PERMANENTLY: {
                return HttpResponseStatus.MOVED_PERMANENTLY;
            }
            case FOUND: {
                return HttpResponseStatus.FOUND;
            }
            case SEE_OTHER: {
                return HttpResponseStatus.SEE_OTHER;
            }
            case NOT_MODIFIED: {
                return HttpResponseStatus.NOT_MODIFIED;
            }
            case USE_PROXY: {
                return HttpResponseStatus.USE_PROXY;
            }
            case TEMPORARY_REDIRECT: {
                return HttpResponseStatus.TEMPORARY_REDIRECT;
            }
            case BAD_REQUEST: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return HttpResponseStatus.UNAUTHORIZED;
            }
            case PAYMENT_REQUIRED: {
                return HttpResponseStatus.PAYMENT_REQUIRED;
            }
            case FORBIDDEN: {
                return HttpResponseStatus.FORBIDDEN;
            }
            case NOT_FOUND: {
                return HttpResponseStatus.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return HttpResponseStatus.METHOD_NOT_ALLOWED;
            }
            case NOT_ACCEPTABLE: {
                return HttpResponseStatus.NOT_ACCEPTABLE;
            }
            case PROXY_AUTHENTICATION: {
                return HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED;
            }
            case REQUEST_TIMEOUT: {
                return HttpResponseStatus.REQUEST_TIMEOUT;
            }
            case CONFLICT: {
                return HttpResponseStatus.CONFLICT;
            }
            case GONE: {
                return HttpResponseStatus.GONE;
            }
            case LENGTH_REQUIRED: {
                return HttpResponseStatus.LENGTH_REQUIRED;
            }
            case PRECONDITION_FAILED: {
                return HttpResponseStatus.PRECONDITION_FAILED;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
            }
            case REQUEST_URI_TOO_LONG: {
                return HttpResponseStatus.REQUEST_URI_TOO_LONG;
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                return HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
            }
            case REQUESTED_RANGE_NOT_SATISFIED: {
                return HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case EXPECTATION_FAILED: {
                return HttpResponseStatus.EXPECTATION_FAILED;
            }
            case UNPROCESSABLE_ENTITY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case LOCKED: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case FAILED_DEPENDENCY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case INTERNAL_SERVER_ERROR: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case NOT_IMPLEMENTED: {
                return HttpResponseStatus.NOT_IMPLEMENTED;
            }
            case BAD_GATEWAY: {
                return HttpResponseStatus.BAD_GATEWAY;
            }
            case SERVICE_UNAVAILABLE: {
                return HttpResponseStatus.SERVICE_UNAVAILABLE;
            }
            case GATEWAY_TIMEOUT: {
                return HttpResponseStatus.GATEWAY_TIMEOUT;
            }
            case HTTP_VERSION_NOT_SUPPORTED: {
                return HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED;
            }
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }
}

