/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.none;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.gateway.none.NoneIndexGatewayModule;

public class NoneGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway,
ClusterStateListener {
    public static final String TYPE = "none";
    private final ClusterService clusterService;
    private final NodeEnvironment nodeEnv;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    @Nullable
    private volatile MetaData currentMetaData;

    @Inject
    public NoneGateway(Settings settings, ClusterService clusterService, NodeEnvironment nodeEnv, NodeIndexDeletedAction nodeIndexDeletedAction) {
        super(settings);
        this.clusterService = clusterService;
        this.nodeEnv = nodeEnv;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        clusterService.addLast(this);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public String toString() {
        return "_none_";
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void performStateRecovery(Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        this.logger.debug("performing state recovery", new Object[0]);
        listener.onSuccess(ClusterState.builder().build());
    }

    @Override
    public Class<? extends Module> suggestIndexGateway() {
        return NoneIndexGatewayModule.class;
    }

    @Override
    public void reset() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            this.currentMetaData = null;
            return;
        }
        MetaData newMetaData = event.state().metaData();
        if (this.currentMetaData != null) {
            for (IndexMetaData current : this.currentMetaData) {
                if (newMetaData.hasIndex(current.index())) continue;
                this.logger.debug("[{}] deleting index that is no longer part of the metadata (indices: [{}])", current.index(), newMetaData.indices().keys());
                if (this.nodeEnv.hasNodeFile()) {
                    FileSystemUtils.deleteRecursively(this.nodeEnv.indexLocations(new Index(current.index())));
                }
                try {
                    this.nodeIndexDeletedAction.nodeIndexStoreDeleted(event.state(), current.index(), event.state().nodes().localNodeId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}] failed to notify master on local index store deletion", e, current.index());
                }
            }
        }
        this.currentMetaData = newMetaData;
    }
}

