/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;

public class ZenDiscoveryModule
extends AbstractModule {
    private final List<Class<? extends UnicastHostsProvider>> unicastHostProviders = Lists.newArrayList();

    public ZenDiscoveryModule addUnicastHostProvider(Class<? extends UnicastHostsProvider> unicastHostProvider) {
        this.unicastHostProviders.add(unicastHostProvider);
        return this;
    }

    @Override
    protected void configure() {
        this.bind(ZenPingService.class).asEagerSingleton();
        Multibinder<UnicastHostsProvider> unicastHostsProviderMultibinder = Multibinder.newSetBinder(this.binder(), UnicastHostsProvider.class);
        for (Class<? extends UnicastHostsProvider> unicastHostProvider : this.unicastHostProviders) {
            unicastHostsProviderMultibinder.addBinding().to(unicastHostProvider);
        }
        this.bindDiscovery();
    }

    protected void bindDiscovery() {
        this.bind(Discovery.class).to(ZenDiscovery.class).asEagerSingleton();
    }
}

