/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;

public class DiscoveryService
extends AbstractLifecycleComponent<DiscoveryService> {
    private final TimeValue initialStateTimeout;
    private final Discovery discovery;
    private volatile boolean initialStateReceived;

    @Inject
    public DiscoveryService(Settings settings, Discovery discovery) {
        super(settings);
        this.discovery = discovery;
        this.initialStateTimeout = this.componentSettings.getAsTime("initial_state_timeout", TimeValue.timeValueSeconds(30L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws ElasticSearchException {
        block6: {
            final CountDownLatch latch = new CountDownLatch(1);
            InitialStateDiscoveryListener listener = new InitialStateDiscoveryListener(){

                @Override
                public void initialStateProcessed() {
                    latch.countDown();
                }
            };
            this.discovery.addListener(listener);
            try {
                this.discovery.start();
                try {
                    this.logger.trace("waiting for {} for the initial state to be set by the discovery", this.initialStateTimeout);
                    if (latch.await(this.initialStateTimeout.millis(), TimeUnit.MILLISECONDS)) {
                        this.logger.trace("initial state set from discovery", new Object[0]);
                        this.initialStateReceived = true;
                        break block6;
                    }
                    this.initialStateReceived = false;
                    this.logger.warn("waited for {} and no initial state was set by the discovery", this.initialStateTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.discovery.removeListener(listener);
            }
        }
        this.logger.info(this.discovery.nodeDescription(), new Object[0]);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.discovery.stop();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.discovery.close();
    }

    public DiscoveryNode localNode() {
        return this.discovery.localNode();
    }

    public boolean initialStateReceived() {
        return this.initialStateReceived;
    }

    public String nodeDescription() {
        return this.discovery.nodeDescription();
    }

    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        if (this.lifecycle.started()) {
            this.discovery.publish(clusterState, ackListener);
        }
    }
}

