/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;

public class XContentMapValues {
    public static List<Object> extractRawValues(String path, Map<String, Object> map2) {
        ArrayList<Object> values2 = Lists.newArrayList();
        String[] pathElements = Strings.splitStringToArray(path, '.');
        if (pathElements.length == 0) {
            return values2;
        }
        XContentMapValues.extractRawValues(values2, map2, pathElements, 0);
        return values2;
    }

    private static void extractRawValues(List values2, Map<String, Object> part, String[] pathElements, int index) {
        int nextIndex;
        if (index == pathElements.length) {
            return;
        }
        String key = pathElements[index];
        Object currentValue = part.get(key);
        for (nextIndex = index + 1; currentValue == null && nextIndex != pathElements.length; ++nextIndex) {
            key = key + "." + pathElements[nextIndex];
            currentValue = part.get(key);
        }
        if (currentValue == null) {
            return;
        }
        if (currentValue instanceof Map) {
            XContentMapValues.extractRawValues(values2, (Map)currentValue, pathElements, nextIndex);
        } else if (currentValue instanceof List) {
            XContentMapValues.extractRawValues(values2, (List)currentValue, pathElements, nextIndex);
        } else {
            values2.add(currentValue);
        }
    }

    private static void extractRawValues(List values2, List<Object> part, String[] pathElements, int index) {
        for (Object value2 : part) {
            if (value2 == null) continue;
            if (value2 instanceof Map) {
                XContentMapValues.extractRawValues(values2, (Map)value2, pathElements, index);
                continue;
            }
            if (value2 instanceof List) {
                XContentMapValues.extractRawValues(values2, (List)value2, pathElements, index);
                continue;
            }
            values2.add(value2);
        }
    }

    public static Object extractValue(String path, Map<String, Object> map2) {
        String[] pathElements = Strings.splitStringToArray(path, '.');
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map2);
    }

    private static Object extractValue(String[] pathElements, int index, Object currentValue) {
        if (index == pathElements.length) {
            return currentValue;
        }
        if (currentValue == null) {
            return null;
        }
        if (currentValue instanceof Map) {
            int nextIndex;
            Map map2 = (Map)currentValue;
            String key = pathElements[index];
            Object mapValue = map2.get(key);
            for (nextIndex = index + 1; mapValue == null && nextIndex != pathElements.length; ++nextIndex) {
                key = key + "." + pathElements[nextIndex];
                mapValue = map2.get(key);
            }
            return XContentMapValues.extractValue(pathElements, nextIndex, mapValue);
        }
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index, o);
                if (listValue == null) continue;
                newList.add(listValue);
            }
            return newList;
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, Object> map2, String[] includes, String[] excludes) {
        HashMap<String, Object> result2 = Maps.newHashMap();
        XContentMapValues.filter(map2, result2, includes == null ? Strings.EMPTY_ARRAY : includes, excludes == null ? Strings.EMPTY_ARRAY : excludes, new StringBuilder());
        return result2;
    }

    private static void filter(Map<String, Object> map2, Map<String, Object> into, String[] includes, String[] excludes, StringBuilder sb) {
        if (includes.length == 0 && excludes.length == 0) {
            into.putAll(map2);
            return;
        }
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            boolean exactIncludeMatch;
            String key = entry2.getKey();
            int mark = sb.length();
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(key);
            String path = sb.toString();
            boolean excluded = false;
            for (String exclude : excludes) {
                if (!Regex.simpleMatch(exclude, path)) continue;
                excluded = true;
                break;
            }
            if (excluded) {
                sb.setLength(mark);
                continue;
            }
            if (includes.length == 0) {
                exactIncludeMatch = true;
            } else {
                exactIncludeMatch = false;
                boolean pathIsPrefixOfAnInclude = false;
                for (String include : includes) {
                    if (include.charAt(0) == '*') {
                        if (Regex.simpleMatch(include, path)) {
                            exactIncludeMatch = true;
                            break;
                        }
                        pathIsPrefixOfAnInclude = true;
                        break;
                    }
                    if (include.startsWith(path)) {
                        if (include.length() == path.length()) {
                            exactIncludeMatch = true;
                            break;
                        }
                        if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                            pathIsPrefixOfAnInclude = true;
                            break;
                        }
                    }
                    if (!Regex.simpleMatch(include, path)) continue;
                    exactIncludeMatch = true;
                    break;
                }
                if (!pathIsPrefixOfAnInclude && !exactIncludeMatch) {
                    sb.setLength(mark);
                    continue;
                }
            }
            if (entry2.getValue() instanceof Map) {
                HashMap<String, Object> innerInto = Maps.newHashMap();
                XContentMapValues.filter((Map)entry2.getValue(), innerInto, exactIncludeMatch ? Strings.EMPTY_ARRAY : includes, excludes, sb);
                if (!innerInto.isEmpty()) {
                    into.put(entry2.getKey(), innerInto);
                }
            } else if (entry2.getValue() instanceof List) {
                List list2 = (List)entry2.getValue();
                ArrayList<Object> innerInto = new ArrayList<Object>(list2.size());
                XContentMapValues.filter(list2, innerInto, exactIncludeMatch ? Strings.EMPTY_ARRAY : includes, excludes, sb);
                into.put(entry2.getKey(), innerInto);
            } else if (exactIncludeMatch) {
                into.put(entry2.getKey(), entry2.getValue());
            }
            sb.setLength(mark);
        }
    }

    private static void filter(List<Object> from2, List<Object> to2, String[] includes, String[] excludes, StringBuilder sb) {
        if (includes.length == 0 && excludes.length == 0) {
            to2.addAll(from2);
            return;
        }
        for (Object o : from2) {
            Cloneable innerInto;
            if (o instanceof Map) {
                innerInto = Maps.newHashMap();
                XContentMapValues.filter((Map)o, innerInto, includes, excludes, sb);
                if (innerInto.isEmpty()) continue;
                to2.add(innerInto);
                continue;
            }
            if (o instanceof List) {
                innerInto = new ArrayList();
                XContentMapValues.filter((List)o, (List<Object>)((Object)innerInto), includes, excludes, sb);
                if (innerInto.isEmpty()) continue;
                to2.add(innerInto);
                continue;
            }
            to2.add(o);
        }
    }

    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node, float defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeFloatValue(node);
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static short nodeShortValue(Object node, short defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeShortValue(node);
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).shortValue();
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node, byte defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeByteValue(node);
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).byteValue();
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).longValue();
        }
        return Long.parseLong(node.toString());
    }

    public static boolean nodeBooleanValue(Object node, boolean defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeBooleanValue(node);
    }

    public static boolean nodeBooleanValue(Object node) {
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue() != 0;
        }
        String value2 = node.toString();
        return !value2.equals("false") && !value2.equals("0") && !value2.equals("off");
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis(((Number)node).longValue());
        }
        return TimeValue.parseTimeValue(node.toString(), null);
    }

    public static Map<String, Object> nodeMapValue(Object node, String desc) {
        if (node instanceof Map) {
            return (Map)node;
        }
        throw new ElasticSearchParseException(desc + " should be a hash but was of type: " + node.getClass());
    }
}

