/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.xcontent.XContentParser;

public abstract class AbstractXContentParser
implements XContentParser {
    static final MapFactory SIMPLE_MAP_FACTORY = new MapFactory(){

        @Override
        public Map<String, Object> newMap() {
            return new HashMap<String, Object>();
        }
    };
    static final MapFactory ORDERED_MAP_FACTORY = new MapFactory(){

        @Override
        public Map<String, Object> newMap() {
            return new LinkedHashMap<String, Object>();
        }
    };

    @Override
    public boolean isBooleanValue() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_NUMBER: {
                XContentParser.NumberType numberType = this.numberType();
                return numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.INT;
            }
            case VALUE_STRING: {
                return Booleans.isBoolean(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    public boolean booleanValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_NUMBER) {
            return this.intValue() != 0;
        }
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBoolean(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    protected abstract boolean doBooleanValue() throws IOException;

    @Override
    public short shortValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Short.parseShort(this.text());
        }
        return this.doShortValue();
    }

    protected abstract short doShortValue() throws IOException;

    @Override
    public int intValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Integer.parseInt(this.text());
        }
        return this.doIntValue();
    }

    protected abstract int doIntValue() throws IOException;

    @Override
    public long longValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Long.parseLong(this.text());
        }
        return this.doLongValue();
    }

    protected abstract long doLongValue() throws IOException;

    @Override
    public float floatValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Float.parseFloat(this.text());
        }
        return this.doFloatValue();
    }

    protected abstract float doFloatValue() throws IOException;

    @Override
    public double doubleValue() throws IOException {
        XContentParser.Token token2 = this.currentToken();
        if (token2 == XContentParser.Token.VALUE_STRING) {
            return Double.parseDouble(this.text());
        }
        return this.doDoubleValue();
    }

    protected abstract double doDoubleValue() throws IOException;

    @Override
    public String textOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public BytesRef bytesOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.bytes();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return AbstractXContentParser.readMap(this);
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return AbstractXContentParser.readOrderedMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> mapAndClose() throws IOException {
        try {
            Map<String, Object> map2 = this.map();
            return map2;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> mapOrderedAndClose() throws IOException {
        try {
            Map<String, Object> map2 = this.mapOrdered();
            return map2;
        }
        finally {
            this.close();
        }
    }

    static Map<String, Object> readMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, SIMPLE_MAP_FACTORY);
    }

    static Map<String, Object> readOrderedMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, ORDERED_MAP_FACTORY);
    }

    static Map<String, Object> readMap(XContentParser parser, MapFactory mapFactory) throws IOException {
        Map<String, Object> map2 = mapFactory.newMap();
        XContentParser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == XContentParser.Token.START_OBJECT) {
            t = parser.nextToken();
        }
        while (t == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            t = parser.nextToken();
            Object value2 = AbstractXContentParser.readValue(parser, mapFactory, t);
            map2.put(fieldName, value2);
            t = parser.nextToken();
        }
        return map2;
    }

    private static List<Object> readList(XContentParser parser, MapFactory mapFactory, XContentParser.Token t) throws IOException {
        ArrayList<Object> list2 = new ArrayList<Object>();
        while ((t = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            list2.add(AbstractXContentParser.readValue(parser, mapFactory, t));
        }
        return list2;
    }

    private static Object readValue(XContentParser parser, MapFactory mapFactory, XContentParser.Token t) throws IOException {
        if (t == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (t == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (t == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (t == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (t == XContentParser.Token.START_OBJECT) {
                return AbstractXContentParser.readMap(parser, mapFactory);
            }
            if (t == XContentParser.Token.START_ARRAY) {
                return AbstractXContentParser.readList(parser, mapFactory, t);
            }
            if (t == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return parser.binaryValue();
            }
        }
        return null;
    }

    static interface MapFactory {
        public Map<String, Object> newMap();
    }
}

