/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.elasticsearch.common.util.concurrent.jsr166e.Striped64;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v, long x2) {
        return Double.doubleToRawLongBits(Double.longBitsToDouble(v) + Double.longBitsToDouble(x2));
    }

    public void add(double x2) {
        long b;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(b = this.base, Double.doubleToRawLongBits(Double.longBitsToDouble(b) + x2))) {
            long v;
            Striped64.Cell a;
            int n;
            boolean uncontended = true;
            Striped64.HashCode hc = (Striped64.HashCode)threadHashCode.get();
            int h = hc.code;
            if (as == null || (n = as.length) < 1 || (a = as[n - 1 & h]) == null || !(uncontended = a.cas(v = a.value, Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x2)))) {
                this.retryUpdate(Double.doubleToRawLongBits(x2), hc, uncontended);
            }
        }
    }

    public double sum() {
        Striped64.Cell[] as = this.cells;
        double sum2 = Double.longBitsToDouble(this.base);
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum2 += Double.longBitsToDouble(a.value);
            }
        }
        return sum2;
    }

    public void reset() {
        this.internalReset(0L);
    }

    public double sumThenReset() {
        Striped64.Cell[] as = this.cells;
        double sum2 = Double.longBitsToDouble(this.base);
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                long v = a.value;
                a.value = 0L;
                sum2 += Double.longBitsToDouble(v);
            }
        }
        return sum2;
    }

    public String toString() {
        return Double.toString(this.sum());
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public long longValue() {
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return (float)this.sum();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeDouble(this.sum());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = Double.doubleToRawLongBits(s.readDouble());
    }
}

