/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsThreadPoolExecutor
extends ThreadPoolExecutor {
    private volatile ShutdownListener listener;
    private final Object monitor = new Object();

    EsThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new EsAbortPolicy());
    }

    EsThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, XRejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ShutdownListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                throw new ElasticSearchIllegalStateException("Shutdown was already called on this thread pool");
            }
            if (this.isTerminated()) {
                listener.onTerminated();
            } else {
                this.listener = listener;
            }
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void terminated() {
        super.terminated();
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                try {
                    this.listener.onTerminated();
                }
                finally {
                    this.listener = null;
                }
            }
        }
    }

    public static interface ShutdownListener {
        public void onTerminated();
    }
}

