/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.common.collect.ImmutableList;

public class AtomicArray<E> {
    private static final AtomicArray EMPTY = new AtomicArray(0);
    private final AtomicReferenceArray<E> array;
    private volatile List<Entry<E>> nonNullList;

    public static <E> E empty() {
        return (E)EMPTY;
    }

    public AtomicArray(int size2) {
        this.array = new AtomicReferenceArray(size2);
    }

    public int length() {
        return this.array.length();
    }

    public void set(int i, E value2) {
        this.array.set(i, value2);
        if (this.nonNullList != null) {
            this.nonNullList = null;
        }
    }

    public E get(int i) {
        return this.array.get(i);
    }

    public List<Entry<E>> asList() {
        if (this.nonNullList == null) {
            if (this.array == null || this.array.length() == 0) {
                this.nonNullList = ImmutableList.of();
            } else {
                ArrayList<Entry<Entry<E>>> list2 = new ArrayList<Entry<Entry<E>>>(this.array.length());
                for (int i = 0; i < this.array.length(); ++i) {
                    E e = this.array.get(i);
                    if (e == null) continue;
                    list2.add(new Entry<E>(i, e));
                }
                this.nonNullList = list2;
            }
        }
        return this.nonNullList;
    }

    public E[] toArray(E[] a) {
        if (a.length != this.array.length()) {
            throw new ElasticSearchGenerationException("AtomicArrays can only be copied to arrays of the same size");
        }
        for (int i = 0; i < this.array.length(); ++i) {
            a[i] = this.array.get(i);
        }
        return a;
    }

    public static class Entry<E> {
        public final int index;
        public final E value;

        public Entry(int index, E value2) {
            this.index = index;
            this.value = value2;
        }
    }
}

