/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.AbstractList;
import java.util.RandomAccess;

public abstract class SlicedObjectList<T>
extends AbstractList<T>
implements RandomAccess {
    public T[] values;
    public int offset;
    public int length;

    public SlicedObjectList(T[] values2) {
        this(values2, 0, values2.length);
    }

    public SlicedObjectList(T[] values2, int offset, int length) {
        this.values = values2;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T get(int index) {
        assert (index < this.size());
        return this.values[this.offset + index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("modifying list opertations are not implemented");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SlicedObjectList) {
            SlicedObjectList that = (SlicedObjectList)object;
            int size2 = this.size();
            if (that.size() != size2) {
                return false;
            }
            for (int i = 0; i < size2; ++i) {
                if (!this.values[this.offset + i].equals(that.values[that.offset + i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.length; ++i) {
            result2 = 31 * result2 + this.values[this.offset + i].hashCode();
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.size() * 10);
        builder.append('[');
        if (this.length > 0) {
            builder.append(this.values[this.offset]);
            for (int i = 1; i < this.length; ++i) {
                builder.append(", ").append(this.values[this.offset + i]);
            }
        }
        return builder.append(']').toString();
    }

    public abstract void grow(int var1);
}

