/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.primitives.Doubles;

public final class SlicedDoubleList
extends AbstractList<Double>
implements RandomAccess {
    public static final SlicedDoubleList EMPTY = new SlicedDoubleList(0);
    public double[] values;
    public int offset;
    public int length;

    public SlicedDoubleList(int capacity) {
        this(new double[capacity], 0, capacity);
    }

    public SlicedDoubleList(double[] values2, int offset, int length) {
        this.values = values2;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Double get(int index) {
        assert (index < this.size());
        return this.values[this.offset + index];
    }

    @Override
    public boolean contains(Object target) {
        return target instanceof Double && SlicedDoubleList.indexOf(this.values, (Double)target, this.offset, this.offset + this.length) != -1;
    }

    @Override
    public int indexOf(Object target) {
        int i;
        if (target instanceof Double && (i = SlicedDoubleList.indexOf(this.values, (Double)target, this.offset, this.offset + this.length)) >= 0) {
            return i - this.offset;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object target) {
        int i;
        if (target instanceof Double && (i = SlicedDoubleList.lastIndexOf(this.values, (Double)target, this.offset, this.offset + this.length)) >= 0) {
            return i - this.offset;
        }
        return -1;
    }

    @Override
    public Double set(int index, Double element) {
        throw new UnsupportedOperationException("modifying list opertations are not implemented");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SlicedDoubleList) {
            SlicedDoubleList that = (SlicedDoubleList)object;
            int size2 = this.size();
            if (that.size() != size2) {
                return false;
            }
            for (int i = 0; i < size2; ++i) {
                if (this.values[this.offset + i] == that.values[that.offset + i]) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.length; ++i) {
            result2 = 31 * result2 + Doubles.hashCode(this.values[this.offset + i]);
        }
        return result2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.size() * 10);
        builder.append('[');
        if (this.length > 0) {
            builder.append(this.values[this.offset]);
            for (int i = 1; i < this.length; ++i) {
                builder.append(", ").append(this.values[this.offset + i]);
            }
        }
        return builder.append(']').toString();
    }

    private static int indexOf(double[] array, double target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(double[] array, double target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public void grow(int newLength) {
        assert (this.offset == 0);
        this.values = ArrayUtil.grow(this.values, newLength);
    }
}

