/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.ObjectArray;

final class BigObjectArray<T>
extends AbstractBigArray
implements ObjectArray<T> {
    public static final int PAGE_SIZE = 16384 / RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    private Object[][] pages;

    public BigObjectArray(long size2) {
        super(PAGE_SIZE);
        this.size = size2;
        this.pages = new Object[this.numPages(size2)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new Object[this.pageSize()];
        }
    }

    @Override
    public T get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return (T)this.pages[pageIndex][indexInPage];
    }

    @Override
    public T set(long index, T value2) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        Object[] page = this.pages[pageIndex];
        Object ret = page[indexInPage];
        page[indexInPage] = value2;
        return (T)ret;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (Object[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = new Object[this.pageSize()];
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
        }
        this.size = newSize;
    }
}

