/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.LongArray;

final class BigLongArray
extends AbstractBigArray
implements LongArray {
    public static final int PAGE_SIZE = 2048;
    private long[][] pages;

    public BigLongArray(long size2) {
        super(2048);
        this.size = size2;
        this.pages = new long[this.numPages(size2)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new long[this.pageSize()];
        }
    }

    @Override
    public long get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public long set(long index, long value2) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = this.pages[pageIndex];
        long ret = page[indexInPage];
        page[indexInPage] = value2;
        return ret;
    }

    @Override
    public long increment(long index, long inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] lArray = this.pages[pageIndex];
        int n = indexInPage;
        long l = lArray[n] + inc;
        lArray[n] = l;
        return l;
    }

    @Override
    protected int numBytesPerElement() {
        return 8;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (long[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = new long[this.pageSize()];
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, long value2) {
        Preconditions.checkArgument(fromIndex <= toIndex);
        int fromPage = this.pageIndex(fromIndex);
        int toPage = this.pageIndex(toIndex - 1L);
        if (fromPage == toPage) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value2);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value2);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value2);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value2);
        }
    }
}

