/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.IntArray;

final class BigIntArray
extends AbstractBigArray
implements IntArray {
    public static final int PAGE_SIZE = 4096;
    private int[][] pages;

    public BigIntArray(long size2) {
        super(4096);
        this.size = size2;
        this.pages = new int[this.numPages(size2)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new int[this.pageSize()];
        }
    }

    @Override
    public int get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public int set(long index, int value2) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = this.pages[pageIndex];
        int ret = page[indexInPage];
        page[indexInPage] = value2;
        return ret;
    }

    @Override
    public int increment(long index, int inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] nArray = this.pages[pageIndex];
        int n = indexInPage;
        int n2 = nArray[n] + inc;
        nArray[n] = n2;
        return n2;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (int[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = new int[this.pageSize()];
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
        }
        this.size = newSize;
    }
}

