/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.BigDoubleArray;
import org.elasticsearch.common.util.BigIntArray;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.BigObjectArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;

public final class BigArrays
extends Enum<BigArrays> {
    public static final int PAGE_SIZE_IN_BYTES = 16384;
    private static final /* synthetic */ BigArrays[] $VALUES;

    public static BigArrays[] values() {
        return (BigArrays[])$VALUES.clone();
    }

    public static BigArrays valueOf(String name) {
        return Enum.valueOf(BigArrays.class, name);
    }

    public static long overSize(long minTargetSize) {
        return BigArrays.overSize(minTargetSize, 2048, 1);
    }

    public static long overSize(long minTargetSize, int pageSize, int bytesPerElement) {
        Preconditions.checkArgument(minTargetSize >= 0L, "minTargetSize must be >= 0");
        Preconditions.checkArgument(pageSize >= 0, "pageSize must be > 0");
        Preconditions.checkArgument(bytesPerElement > 0, "bytesPerElement must be > 0");
        long newSize = minTargetSize < (long)pageSize ? (long)ArrayUtil.oversize((int)minTargetSize, bytesPerElement) : minTargetSize + (minTargetSize >>> 3);
        if (newSize > (long)pageSize) {
            newSize = newSize - newSize % (long)pageSize + (long)pageSize;
            assert (newSize % (long)pageSize == 0L);
        }
        return newSize;
    }

    static boolean indexIsInt(long index) {
        return index == (long)((int)index);
    }

    public static IntArray newIntArray(long size2) {
        if (size2 <= 4096L) {
            return new IntArrayWrapper(new int[(int)size2]);
        }
        return new BigIntArray(size2);
    }

    public static IntArray resize(IntArray array, long size2) {
        if (array instanceof BigIntArray) {
            ((BigIntArray)array).resize(size2);
            return array;
        }
        IntArray newArray = BigArrays.newIntArray(size2);
        long end = Math.min(size2, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static IntArray grow(IntArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return BigArrays.resize(array, newSize);
    }

    public static LongArray newLongArray(long size2) {
        if (size2 <= 2048L) {
            return new LongArrayWrapper(new long[(int)size2]);
        }
        return new BigLongArray(size2);
    }

    public static LongArray resize(LongArray array, long size2) {
        if (array instanceof BigLongArray) {
            ((BigLongArray)array).resize(size2);
            return array;
        }
        LongArray newArray = BigArrays.newLongArray(size2);
        long end = Math.min(size2, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static LongArray grow(LongArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return BigArrays.resize(array, newSize);
    }

    public static DoubleArray newDoubleArray(long size2) {
        if (size2 <= 2048L) {
            return new DoubleArrayWrapper(new double[(int)size2]);
        }
        return new BigDoubleArray(size2);
    }

    public static DoubleArray resize(DoubleArray array, long size2) {
        if (array instanceof BigDoubleArray) {
            ((BigDoubleArray)array).resize(size2);
            return array;
        }
        DoubleArray newArray = BigArrays.newDoubleArray(size2);
        long end = Math.min(size2, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static DoubleArray grow(DoubleArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return BigArrays.resize(array, newSize);
    }

    public static <T> ObjectArray<T> newObjectArray(long size2) {
        if (size2 <= 2048L) {
            return new ObjectArrayWrapper(new Object[(int)size2]);
        }
        return new BigObjectArray(size2);
    }

    public static <T> ObjectArray<T> resize(ObjectArray<T> array, long size2) {
        if (array instanceof BigObjectArray) {
            ((BigObjectArray)array).resize(size2);
            return array;
        }
        ObjectArray<T> newArray = BigArrays.newObjectArray(size2);
        long end = Math.min(size2, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static <T> ObjectArray<T> grow(ObjectArray<T> array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, BigObjectArray.PAGE_SIZE, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        return BigArrays.resize(array, newSize);
    }

    static {
        $VALUES = new BigArrays[0];
    }

    private static class ObjectArrayWrapper<T>
    implements ObjectArray<T> {
        private final Object[] array;

        ObjectArrayWrapper(Object[] array) {
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public T get(long index) {
            assert (BigArrays.indexIsInt(index));
            return (T)this.array[(int)index];
        }

        @Override
        public T set(long index, T value2) {
            assert (BigArrays.indexIsInt(index));
            Object ret = this.array[(int)index];
            this.array[(int)index] = value2;
            return (T)ret;
        }
    }

    private static class DoubleArrayWrapper
    implements DoubleArray {
        private final double[] array;

        DoubleArrayWrapper(double[] array) {
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public double get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public double set(long index, double value2) {
            assert (BigArrays.indexIsInt(index));
            double ret = this.array[(int)index];
            this.array[(int)index] = value2;
            return ret;
        }

        @Override
        public double increment(long index, double inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            double d = this.array[n] + inc;
            this.array[n] = d;
            return d;
        }

        @Override
        public void fill(long fromIndex, long toIndex, double value2) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value2);
        }
    }

    private static class LongArrayWrapper
    implements LongArray {
        private final long[] array;

        LongArrayWrapper(long[] array) {
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public long get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public long set(long index, long value2) {
            assert (BigArrays.indexIsInt(index));
            long ret = this.array[(int)index];
            this.array[(int)index] = value2;
            return ret;
        }

        @Override
        public long increment(long index, long inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            long l = this.array[n] + inc;
            this.array[n] = l;
            return l;
        }

        @Override
        public void fill(long fromIndex, long toIndex, long value2) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value2);
        }
    }

    private static class IntArrayWrapper
    implements IntArray {
        private final int[] array;

        IntArrayWrapper(int[] array) {
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public int get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public int set(long index, int value2) {
            assert (BigArrays.indexIsInt(index));
            int ret = this.array[(int)index];
            this.array[(int)index] = value2;
            return ret;
        }

        @Override
        public int increment(long index, int inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            int n2 = this.array[n] + inc;
            this.array[n] = n2;
            return n2;
        }
    }
}

