/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.elasticsearch.common.base.Preconditions;

abstract class AbstractBigArray {
    private final int pageShift;
    private final int pageMask;
    protected long size;

    protected AbstractBigArray(int pageSize) {
        Preconditions.checkArgument(pageSize >= 128, "pageSize must be >= 128");
        Preconditions.checkArgument((pageSize & pageSize - 1) == 0, "pageSize must be a power of two");
        this.pageShift = Integer.numberOfTrailingZeros(pageSize);
        this.pageMask = pageSize - 1;
        this.size = 0L;
    }

    final int numPages(long capacity) {
        long numPages = capacity + (long)this.pageMask >>> this.pageShift;
        Preconditions.checkArgument(numPages <= Integer.MAX_VALUE, "pageSize=" + (this.pageMask + 1) + " is too small for such as capacity: " + capacity);
        return (int)numPages;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    public final long size() {
        return this.size;
    }

    protected abstract int numBytesPerElement();

    public final long sizeInBytes() {
        return ((long)this.pageIndex(this.size - 1L) + 1L) * (long)this.pageSize() * (long)this.numBytesPerElement();
    }
}

