/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

public enum ByteSizeUnit {
    BYTES{

        @Override
        public long toBytes(long size2) {
            return size2;
        }

        @Override
        public long toKB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toMB(long size2) {
            return size2 / 0x100000L;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 0x40000000L;
        }

        @Override
        public long toTB(long size2) {
            return size2 / 0x10000000000L;
        }

        @Override
        public long toPB(long size2) {
            return size2 / 0x4000000000000L;
        }
    }
    ,
    KB{

        @Override
        public long toBytes(long size2) {
            return 2.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return size2;
        }

        @Override
        public long toMB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 0x100000L;
        }

        @Override
        public long toTB(long size2) {
            return size2 / 0x40000000L;
        }

        @Override
        public long toPB(long size2) {
            return size2 / 0x10000000000L;
        }
    }
    ,
    MB{

        @Override
        public long toBytes(long size2) {
            return 3.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return 3.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return size2;
        }

        @Override
        public long toGB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toTB(long size2) {
            return size2 / 0x100000L;
        }

        @Override
        public long toPB(long size2) {
            return size2 / 0x40000000L;
        }
    }
    ,
    GB{

        @Override
        public long toBytes(long size2) {
            return 4.x(size2, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return 4.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return 4.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGB(long size2) {
            return size2;
        }

        @Override
        public long toTB(long size2) {
            return size2 / 1024L;
        }

        @Override
        public long toPB(long size2) {
            return size2 / 0x100000L;
        }
    }
    ,
    TB{

        @Override
        public long toBytes(long size2) {
            return 5.x(size2, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKB(long size2) {
            return 5.x(size2, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return 5.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGB(long size2) {
            return 5.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTB(long size2) {
            return size2;
        }

        @Override
        public long toPB(long size2) {
            return size2 / 1024L;
        }
    }
    ,
    PB{

        @Override
        public long toBytes(long size2) {
            return 6.x(size2, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKB(long size2) {
            return 6.x(size2, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMB(long size2) {
            return 6.x(size2, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGB(long size2) {
            return 6.x(size2, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTB(long size2) {
            return 6.x(size2, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPB(long size2) {
            return size2;
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long C4 = 0x10000000000L;
    static final long C5 = 0x4000000000000L;
    static final long MAX = Long.MAX_VALUE;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public abstract long toBytes(long var1);

    public abstract long toKB(long var1);

    public abstract long toMB(long var1);

    public abstract long toGB(long var1);

    public abstract long toTB(long var1);

    public abstract long toPB(long var1);
}

