/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportAddressSerializers {
    private static final ESLogger logger = Loggers.getLogger(TransportAddressSerializers.class);
    private static ImmutableMap<Short, Constructor<? extends TransportAddress>> addressConstructors = ImmutableMap.of();

    public static synchronized void addAddressType(TransportAddress address) throws Exception {
        if (addressConstructors.containsKey(address.uniqueAddressTypeId())) {
            throw new ElasticSearchIllegalStateException("Address [" + address.uniqueAddressTypeId() + "] already bound");
        }
        Constructor<?> constructor = address.getClass().getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        addressConstructors = MapBuilder.newMapBuilder(addressConstructors).put(address.uniqueAddressTypeId(), constructor).immutableMap();
    }

    public static TransportAddress addressFromStream(StreamInput input2) throws IOException {
        TransportAddress address;
        short addressUniqueId = input2.readShort();
        Constructor<? extends TransportAddress> constructor = addressConstructors.get(addressUniqueId);
        if (constructor == null) {
            throw new IOException("No transport address mapped to [" + addressUniqueId + "]");
        }
        try {
            address = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Failed to create class with constructor [" + constructor + "]", e);
        }
        address.readFrom(input2);
        return address;
    }

    public static void addressToStream(StreamOutput out, TransportAddress address) throws IOException {
        out.writeShort(address.uniqueAddressTypeId());
        address.writeTo(out);
    }

    static {
        try {
            TransportAddressSerializers.addAddressType(DummyTransportAddress.INSTANCE);
            TransportAddressSerializers.addAddressType(new InetSocketTransportAddress());
            TransportAddressSerializers.addAddressType(new LocalTransportAddress());
        }
        catch (Exception e) {
            logger.warn("Failed to add InetSocketTransportAddress", e, new Object[0]);
        }
    }
}

