/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import java.util.Comparator;
import org.elasticsearch.common.bytes.BytesReference;

public class UTF8SortedAsUnicodeComparator
implements Comparator<BytesReference> {
    public static final Comparator<BytesReference> utf8SortedAsUnicodeSortOrder = new UTF8SortedAsUnicodeComparator();

    private UTF8SortedAsUnicodeComparator() {
    }

    @Override
    public int compare(BytesReference a, BytesReference b) {
        if (a.hasArray() && b.hasArray()) {
            byte[] aBytes = a.array();
            int aUpto = a.arrayOffset();
            byte[] bBytes = b.array();
            int bUpto = b.arrayOffset();
            int aStop = aUpto + Math.min(a.length(), b.length());
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                int diff2;
                if ((diff2 = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
                return diff2;
            }
            return a.length() - b.length();
        }
        byte[] aBytes = a.toBytes();
        int aUpto = 0;
        byte[] bBytes = b.toBytes();
        int bUpto = 0;
        int aStop = aUpto + Math.min(a.length(), b.length());
        while (aUpto < aStop) {
            int bByte;
            int aByte;
            int diff3;
            if ((diff3 = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
            return diff3;
        }
        return a.length() - b.length();
    }
}

