/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.text.UTF8SortedAsUnicodeComparator;

public class BytesText
implements Text {
    private BytesReference bytes;
    private int hash;

    public BytesText(BytesReference bytes) {
        this.bytes = bytes;
    }

    @Override
    public boolean hasBytes() {
        return true;
    }

    @Override
    public BytesReference bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasString() {
        return false;
    }

    @Override
    public String string() {
        if (!this.bytes.hasArray()) {
            this.bytes = this.bytes.toBytesArray();
        }
        return new String(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.length(), Charsets.UTF_8);
    }

    @Override
    public String toString() {
        return this.string();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.bytes.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this.bytes().equals(((Text)obj).bytes());
    }

    @Override
    public int compareTo(Text text2) {
        return UTF8SortedAsUnicodeComparator.utf8SortedAsUnicodeSortOrder.compare(this.bytes(), text2.bytes());
    }
}

