/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public abstract class XContentSettingsLoader
implements SettingsLoader {
    public abstract XContentType contentType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> load(String source) throws IOException {
        XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(source);
        try {
            Map<String, String> map2 = this.load(parser);
            return map2;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> load(byte[] source) throws IOException {
        XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(source);
        try {
            Map<String, String> map2 = this.load(parser);
            return map2;
        }
        finally {
            parser.close();
        }
    }

    public Map<String, String> load(XContentParser jp) throws IOException {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> settings = Maps.newHashMap();
        ArrayList<String> path = Lists.newArrayList();
        XContentParser.Token token2 = jp.nextToken();
        if (token2 == null) {
            return settings;
        }
        if (token2 != XContentParser.Token.START_OBJECT) {
            throw new ElasticSearchParseException("malformed, expected settings to start with 'object', instead was [" + (Object)((Object)token2) + "]");
        }
        this.serializeObject(settings, sb, path, jp, null);
        return settings;
    }

    private void serializeObject(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String objFieldName) throws IOException {
        XContentParser.Token token2;
        if (objFieldName != null) {
            path.add(objFieldName);
        }
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.VALUE_NULL) continue;
            this.serializeValue(settings, sb, path, parser, currentFieldName);
        }
        if (objFieldName != null) {
            path.remove(path.size() - 1);
        }
    }

    private void serializeArray(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName) throws IOException {
        XContentParser.Token token2;
        int counter = 0;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token2 == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token2 == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.VALUE_NULL) continue;
            this.serializeValue(settings, sb, path, parser, fieldName + '.' + counter++);
        }
    }

    private void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName) throws IOException {
        sb.setLength(0);
        for (String pathEle : path) {
            sb.append(pathEle).append('.');
        }
        sb.append(fieldName);
        settings.put(sb.toString(), parser.text());
    }
}

