/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;

public interface SettingsLoader {
    public Map<String, String> load(String var1) throws IOException;

    public Map<String, String> load(byte[] var1) throws IOException;

    public static class Helper {
        public static Map<String, String> loadNestedFromMap(@Nullable Map map2) {
            HashMap<String, String> settings = Maps.newHashMap();
            if (map2 == null) {
                return settings;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> path = Lists.newArrayList();
            Helper.serializeMap(settings, sb, path, map2);
            return settings;
        }

        private static void serializeMap(Map<String, String> settings, StringBuilder sb, List<String> path, Map<Object, Object> map2) {
            for (Map.Entry<Object, Object> entry2 : map2.entrySet()) {
                if (entry2.getValue() instanceof Map) {
                    path.add((String)entry2.getKey());
                    Helper.serializeMap(settings, sb, path, (Map)entry2.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                if (entry2.getValue() instanceof List) {
                    path.add((String)entry2.getKey());
                    Helper.serializeList(settings, sb, path, (List)entry2.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                Helper.serializeValue(settings, sb, path, (String)entry2.getKey(), entry2.getValue());
            }
        }

        private static void serializeList(Map<String, String> settings, StringBuilder sb, List<String> path, List list2) {
            int counter = 0;
            for (Object listEle : list2) {
                if (listEle instanceof Map) {
                    path.add(Integer.toString(counter));
                    Helper.serializeMap(settings, sb, path, (Map)listEle);
                    path.remove(path.size() - 1);
                } else if (listEle instanceof List) {
                    path.add(Integer.toString(counter));
                    Helper.serializeList(settings, sb, path, (List)listEle);
                    path.remove(path.size() - 1);
                } else {
                    Helper.serializeValue(settings, sb, path, Integer.toString(counter), listEle);
                }
                ++counter;
            }
        }

        private static void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, String name, Object value2) {
            if (value2 == null) {
                return;
            }
            sb.setLength(0);
            for (String pathEle : path) {
                sb.append(pathEle).append('.');
            }
            sb.append(name);
            settings.put(sb.toString(), value2.toString());
        }
    }
}

