/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class SettingsFilter
extends AbstractComponent {
    private final CopyOnWriteArrayList<Filter> filters = new CopyOnWriteArrayList();

    @Inject
    public SettingsFilter(Settings settings) {
        super(settings);
    }

    public void addFilter(Filter filter2) {
        this.filters.add(filter2);
    }

    public void removeFilter(Filter filter2) {
        this.filters.remove(filter2);
    }

    public Settings filterSettings(Settings settings) {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(settings);
        for (Filter filter2 : this.filters) {
            filter2.filter(builder);
        }
        return builder.build();
    }

    public static interface Filter {
        public void filter(ImmutableSettings.Builder var1);
    }
}

